/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.data;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.domumornamentum.IDomumOrnamentumApi;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record MaterialTextureData(Map<ResourceLocation, Block> getTexturedComponents) {
    public static final MaterialTextureData EMPTY = new MaterialTextureData(Map.of());
    public static final Codec<MaterialTextureData> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)BuiltInRegistries.BLOCK.byNameCodec()).xmap(MaterialTextureData::fromCodec, MaterialTextureData::getTexturedComponents);
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialTextureData> STREAM_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK)).map(MaterialTextureData::fromCodec, MaterialTextureData::getTexturedComponents);

    private static MaterialTextureData fromCodec(Map<ResourceLocation, Block> texturedComponents) {
        return texturedComponents.isEmpty() ? EMPTY : new MaterialTextureData(texturedComponents);
    }

    public static Builder builder() {
        return new Builder();
    }

    public MaterialTextureData retainComponentsFromBlock(IMateriallyTexturedBlock block) {
        int localComponentsPresent = 0;
        for (IMateriallyTexturedBlockComponent component : block.getComponents()) {
            if (!this.getTexturedComponents().containsKey(component.getId())) continue;
            ++localComponentsPresent;
        }
        if (localComponentsPresent == this.getTexturedComponents().size()) {
            return this;
        }
        Builder newData = new Builder();
        block.getComponents().forEach(comp -> newData.setComponent(comp.getId(), this.getTexturedComponents().get(comp.getId())));
        return newData.build();
    }

    @Deprecated(forRemoval=true, since="1.21")
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isEmpty()) {
            return nbt;
        }
        this.getTexturedComponents().forEach((key, value) -> nbt.putString(key.toString(), Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey(value)).toString()));
        return nbt;
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static MaterialTextureData deserializeFromNBT(CompoundTag nbt) {
        if (nbt == null || nbt.isEmpty()) {
            return EMPTY;
        }
        Builder newData = new Builder();
        nbt.getAllKeys().forEach(key -> {
            ResourceLocation name = ResourceLocation.parse((String)nbt.getString(key));
            if (BuiltInRegistries.BLOCK.get(name) != Blocks.AIR) {
                newData.setComponent(ResourceLocation.parse((String)key), (Block)BuiltInRegistries.BLOCK.get(name));
            }
        });
        return newData.build();
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(IDomumOrnamentumApi.getInstance().getMaterialTextureComponentType(), (Object)(this.isEmpty() ? EMPTY : this));
    }

    public static MaterialTextureData readFromItemStack(ItemStack itemStack) {
        return (MaterialTextureData)itemStack.getOrDefault(IDomumOrnamentumApi.getInstance().getMaterialTextureComponentType(), (Object)EMPTY);
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<MaterialTextureData> updater) {
        ((MaterialTextureData)updater.apply(MaterialTextureData.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.equals(EMPTY);
    }

    public static class Builder {
        private final ImmutableMap.Builder<ResourceLocation, Block> texturedComponents = ImmutableMap.builder();

        public Builder setComponent(ResourceLocation key, Block value) {
            this.texturedComponents.put((Object)key, (Object)value);
            return this;
        }

        public MaterialTextureData build() {
            return new MaterialTextureData((Map<ResourceLocation, Block>)this.texturedComponents.build());
        }

        public void writeToItemStack(ItemStack itemStack) {
            itemStack.set(IDomumOrnamentumApi.getInstance().getMaterialTextureComponentType(), (Object)this.build());
        }
    }
}

