/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public enum ModRenderTypes {
    MEASUREMENT_LINES(() -> InternalType.MEASUREMENT_LINES),
    CHISEL_PREVIEW_INSIDE_BLOCKS(() -> InternalType.CHISEL_PREVIEW_INSIDE_BLOCKS),
    CHISEL_PREVIEW_OUTSIDE_BLOCKS(() -> InternalType.CHISEL_PREVIEW_OUTSIDE_BLOCKS),
    WIREFRAME_LINES(() -> InternalType.WIREFRAME_LINES),
    WIREFRAME_LINES_ALWAYS(() -> InternalType.WIREFRAME_LINES_ALWAYS),
    WIREFRAME_BODY(() -> InternalType.WIREFRAME_BODY),
    GHOST_BLOCK_PREVIEW(() -> InternalType.GHOST_BLOCK_PREVIEW),
    GHOST_BLOCK_PREVIEW_GREATER(() -> InternalType.GHOST_BLOCK_PREVIEW_GREATER),
    GHOST_BLOCK_COLORED_PREVIEW(() -> InternalType.GHOST_BLOCK_COLORED_PREVIEW),
    GHOST_BLOCK_COLORED_PREVIEW_ALWAYS(() -> InternalType.GHOST_BLOCK_COLORED_PREVIEW_ALWAYS);

    private final Supplier<RenderType> typeSupplier;

    private ModRenderTypes(Supplier<RenderType> typeSupplier) {
        this.typeSupplier = typeSupplier;
    }

    public RenderType get() {
        return this.typeSupplier.get();
    }

    private static class InternalType
    extends RenderType {
        private static final RenderType MEASUREMENT_LINES = RenderType.create((String)"domum_ornamentum:measurement_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(InternalState.DISABLED_DEPTH_TEST).createCompositeState(false));
        private static final RenderType CHISEL_PREVIEW_INSIDE_BLOCKS = RenderType.create((String)"domum_ornamentum:chisel_preview_inside_blocks", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState((RenderStateShard.DepthTestStateShard)InternalState.GREATER_OR_EQUAL_DEPTH_TEST).createCompositeState(false));
        private static final RenderType CHISEL_PREVIEW_OUTSIDE_BLOCKS = RenderType.create((String)"domum_ornamentum:chisel_preview_outside_blocks", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState((RenderStateShard.DepthTestStateShard)InternalState.LESS_OR_EQUAL_DEPTH_TEST).createCompositeState(false));
        private static final RenderType WIREFRAME_LINES = InternalType.buildWireframeType(false);
        private static final RenderType WIREFRAME_LINES_ALWAYS = InternalType.buildWireframeType(true);
        private static final RenderType WIREFRAME_BODY = RenderType.create((String)"domum_ornamentum:wireframe_body", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_SOLID_SHADER).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(NO_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(NO_DEPTH_TEST).createCompositeState(false));
        private static final RenderStateShard.TextureStateShard BLOCK_TEXTURE = new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false);
        private static final RenderStateShard.DepthTestStateShard GREATER_DEPTH_TEST = new RenderStateShard.DepthTestStateShard(">", 516);
        private static final RenderType GHOST_BLOCK_PREVIEW = InternalType.buildGhostType(false);
        private static final RenderType GHOST_BLOCK_PREVIEW_GREATER = InternalType.buildGhostType(true);
        private static final RenderType GHOST_BLOCK_COLORED_PREVIEW = InternalType.buildColoredGhostType(false);
        private static final RenderType GHOST_BLOCK_COLORED_PREVIEW_ALWAYS = InternalType.buildColoredGhostType(true);

        private static RenderType buildWireframeType(boolean always) {
            return RenderType.create((String)("domum_ornamentum:wireframe_lines" + (always ? "_always" : "")), (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(always ? InternalState.DISABLED_DEPTH_TEST : LEQUAL_DEPTH_TEST).createCompositeState(false));
        }

        private static RenderType buildGhostType(boolean greater) {
            if (!greater) {
                return Sheets.translucentCullBlockSheet();
            }
            return RenderType.create((String)"domum_ornamentum:ghost_block_preview_greater", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_TEXTURE).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).setDepthTestState(GREATER_DEPTH_TEST).createCompositeState(false));
        }

        private static RenderType buildColoredGhostType(boolean always) {
            return RenderType.create((String)("domum_ornamentum:ghost_block_colored_preview" + (always ? "_always" : "")), (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setDepthTestState(always ? InternalState.DISABLED_DEPTH_TEST : LEQUAL_DEPTH_TEST).createCompositeState(false));
        }

        private InternalType(String name, VertexFormat fmt, VertexFormat.Mode glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated");
        }
    }

    private static class InternalState
    extends RenderStateShard {
        private static final RenderStateShard.DepthTestStateShard DISABLED_DEPTH_TEST = new DepthTestDisabled();
        private static final DepthTestLessOrEqual LESS_OR_EQUAL_DEPTH_TEST = new DepthTestLessOrEqual();
        private static final DepthTestGreaterOrEqual GREATER_OR_EQUAL_DEPTH_TEST = new DepthTestGreaterOrEqual();

        public InternalState(String name, Runnable setupState, Runnable clearState) {
            super(name, setupState, clearState);
            throw new IllegalStateException("This class must not be instantiated");
        }

        private static class DepthTestDisabled
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestDisabled() {
                super("depth_test_disabled", 0);
            }

            public void setupRenderState() {
                RenderSystem.disableDepthTest();
            }

            public void clearRenderState() {
                RenderSystem.enableDepthTest();
            }

            @NotNull
            public String toString() {
                return this.name + "[domum_ornamentum:depth_test_disabled]";
            }
        }

        private static class DepthTestLessOrEqual
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestLessOrEqual() {
                super("depth_test_less_or_equal", 0);
            }

            public void setupRenderState() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            public void clearRenderState() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            @NotNull
            public String toString() {
                return this.name + "[domum_ornamentum:depth_test_less_or_equal]";
            }
        }

        private static class DepthTestGreaterOrEqual
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestGreaterOrEqual() {
                super("depth_test_greater_or_equal", 0);
            }

            public void setupRenderState() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)518);
            }

            public void clearRenderState() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            @NotNull
            public String toString() {
                return this.name + "[domum_ornamentum:depth_test_greater_or_equal]";
            }
        }
    }
}

