/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.screens;

import com.ldtteam.domumornamentum.DomumOrnamentum;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.container.ArchitectsCutterContainer;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterScreen
extends AbstractContainerScreen<ArchitectsCutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE1 = Constants.resLocDO("textures/gui/container/architectscutter.png");
    private static final ResourceLocation BACKGROUND_TEXTURE2 = Constants.resLocDO("textures/gui/container/architectscutter2.png");
    private float recipeSliderProgress;
    private boolean clickedOnRecipeScroll;
    private int recipeIndexOffset;
    private float typeSliderProgress;
    private boolean clickedOnTypeScroll;
    private int typeIndexOffset;
    private static int groupIndexCache = 0;
    private static int variantIndexCache = -1;

    public ArchitectsCutterScreen(ArchitectsCutterContainer containerIn, Inventory playerInv, Component titleIn) {
        super((AbstractContainerMenu)containerIn, playerInv, titleIn);
        --this.titleLabelY;
        this.imageWidth = 242;
        this.imageHeight = 202;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        int guiLeft = this.leftPos;
        int guiTop = this.topPos;
        graphics.blit(this.getBackGroundTexture(), guiLeft, guiTop, 0, 0, this.imageWidth, this.imageHeight);
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() == null) {
            ((ArchitectsCutterContainer)this.menu).clickMenuButton((Player)Objects.requireNonNull(Objects.requireNonNull(this.minecraft).player), groupIndexCache);
            Objects.requireNonNull(this.minecraft.gameMode).handleInventoryButtonClick(((ArchitectsCutterContainer)this.menu).containerId, groupIndexCache);
        }
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null && ((ArchitectsCutterContainer)this.menu).getCurrentVariant() == null) {
            if (variantIndexCache == -1) {
                variantIndexCache = ModBlocks.getInstance().itemGroups.size();
            }
            ((ArchitectsCutterContainer)this.menu).clickMenuButton((Player)Objects.requireNonNull(Objects.requireNonNull(this.minecraft).player), variantIndexCache);
            Objects.requireNonNull(this.minecraft.gameMode).handleInventoryButtonClick(((ArchitectsCutterContainer)this.menu).containerId, variantIndexCache);
        }
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null) {
            int sliderOffset1 = (int)(5.0f * this.recipeSliderProgress);
            graphics.blit(this.getBackGroundTexture(), guiLeft + 220, guiTop + 17 + 23 + sliderOffset1, 0 + (this.canScrollRecipes() ? 0 : 12), 220, 12, 15);
        }
        int sliderOffset2 = (int)(5.0f * this.typeSliderProgress);
        graphics.blit(this.getBackGroundTexture(), guiLeft + 220, guiTop + 17 + sliderOffset2, 0 + (this.canScrollTypes() ? 0 : 12), 220, 12, 15);
        int recipeAreaLeft = this.leftPos + 57;
        int recipeAreaTop = this.topPos + 16;
        this.drawSlotBackgrounds(graphics);
        this.drawRecipeButtonBackgrounds(graphics, x, y, recipeAreaLeft, recipeAreaTop);
        this.drawRecipesItems(graphics, recipeAreaLeft, recipeAreaTop);
    }

    private ResourceLocation getBackGroundTexture() {
        return ((ArchitectsCutterContainer)this.menu).getCurrentGroup() == null ? BACKGROUND_TEXTURE1 : BACKGROUND_TEXTURE2;
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int x, int y) {
        int k1;
        int j1;
        int i1;
        int l;
        super.renderTooltip(graphics, x, y);
        int i = this.leftPos + 57;
        int j = this.topPos + 16;
        int k = this.typeIndexOffset + 10;
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (l = this.typeIndexOffset; l < k && l < list.size(); ++l) {
            i1 = l - this.typeIndexOffset;
            j1 = i + i1 % 10 * 16;
            k1 = j + i1 / 10 * 18 + 2;
            if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)("cuttergroup." + ((ResourceLocation)list.get(l)).getNamespace() + "." + ((ResourceLocation)list.get(l)).getPath())), x, y);
        }
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null) {
            List<ItemStack> list2 = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.menu).getCurrentGroup());
            int i2 = this.leftPos + 57;
            int j2 = this.topPos + 16 + 23;
            int k2 = this.recipeIndexOffset + 10;
            for (l = this.recipeIndexOffset; l < k2 && l < list2.size(); ++l) {
                ItemStack stack;
                i1 = l - this.recipeIndexOffset;
                j1 = i2 + i1 % 10 * 16;
                k1 = j2 + i1 / 10 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                if (((ArchitectsCutterContainer)this.menu).outputInventorySlot.hasItem()) {
                    ItemStack input = list2.get(l).copy();
                    this.texturizeVariantUsingCurrentInput(input);
                    stack = input;
                } else {
                    stack = list2.get(l);
                }
                graphics.renderTooltip(this.font, stack, x, y);
            }
        }
    }

    protected void renderLabels(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
        p_281635_.drawString(this.font, (Component)Component.translatable((String)"domum_ornamentum.group"), 7, 22, 0x404040, false);
        p_281635_.drawString(this.font, (Component)Component.translatable((String)"domum_ornamentum.variant"), 7, 45, 0x404040, false);
        p_281635_.drawString(this.font, this.title, this.titleLabelX + 70, this.titleLabelY, 0x404040, false);
        p_281635_.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX + 32, this.inventoryLabelY + 36, 0x404040, false);
    }

    private void drawRecipeButtonBackgrounds(GuiGraphics graphics, int x, int y, int recipeAreaLeft, int recipeAreaTop) {
        ArrayList<ResourceLocation> groups = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (int i = this.typeIndexOffset; i < this.typeIndexOffset + 10 && i < groups.size(); ++i) {
            int drawIndex = i - this.typeIndexOffset;
            int drawLeft = recipeAreaLeft + drawIndex % 10 * 16;
            int rowIndex = drawIndex / 10;
            int drawTop = recipeAreaTop + rowIndex * 18 + 2;
            int zOffset = 32;
            if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null && i == groups.indexOf(((ArchitectsCutterContainer)this.menu).getCurrentGroup())) {
                zOffset = 0;
            } else if (x >= drawLeft && y >= drawTop && x < drawLeft + 16 && y < drawTop + 18) {
                zOffset = 16;
            }
            graphics.blit(BACKGROUND_TEXTURE1, drawLeft, drawTop - 1, zOffset, 202, 16, 18);
        }
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null) {
            List<ItemStack> list = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.menu).getCurrentGroup());
            for (int i = this.recipeIndexOffset; i < this.recipeIndexOffset + 10 && i < list.size(); ++i) {
                int drawIndex = i - this.recipeIndexOffset;
                int drawLeft = recipeAreaLeft + drawIndex % 10 * 16;
                int rowIndex = drawIndex / 10;
                int drawTop = recipeAreaTop + 23 + rowIndex * 18 + 2;
                int zOffset = 32;
                if (((ArchitectsCutterContainer)this.menu).getCurrentVariant() != null && i == list.indexOf(((ArchitectsCutterContainer)this.menu).getCurrentVariant())) {
                    zOffset = 0;
                } else if (x >= drawLeft && y >= drawTop && x < drawLeft + 16 && y < drawTop + 18) {
                    zOffset = 16;
                }
                graphics.blit(BACKGROUND_TEXTURE1, drawLeft, drawTop - 1, zOffset, 202, 16, 18);
            }
        }
    }

    private void drawSlotBackgrounds(GuiGraphics graphics) {
        BlockItem item;
        Item item2;
        if (((ArchitectsCutterContainer)this.menu).getCurrentVariant() != null && (item2 = ((ArchitectsCutterContainer)this.menu).getCurrentVariant().getItem()) instanceof BlockItem && (item2 = (item = (BlockItem)item2).getBlock()) instanceof IMateriallyTexturedBlock) {
            IMateriallyTexturedBlock block = (IMateriallyTexturedBlock)item2;
            int numComponents = block.getComponents().size();
            ArrayList<ResourceLocation> input = new ArrayList<ResourceLocation>();
            if (item instanceof IDoItem) {
                IDoItem doItem = (IDoItem)item;
                input.addAll(doItem.getInputIds());
            }
            for (int i = 0; i < 2; ++i) {
                int drawLeft = 95 + this.leftPos;
                int drawTop = this.topPos + 66 - 1 + i * 20;
                if (i < input.size()) {
                    graphics.drawString(this.font, (Component)Component.translatable((String)(((ResourceLocation)input.get(i)).getNamespace() + ".desc." + ((ResourceLocation)input.get(i)).getPath()), (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{""})}), drawLeft - 88, drawTop + 5, 0x404040, false);
                }
                graphics.blit(BACKGROUND_TEXTURE1, drawLeft, drawTop, 48 + (i >= numComponents ? 18 : 0), 202, 18, 18);
            }
        }
    }

    private void drawRecipesItems(@NotNull GuiGraphics graphics, int left, int top) {
        ArrayList<ResourceLocation> typeList = new ArrayList<ResourceLocation>(ModBlocks.getInstance().getOrComputeItemGroups().keySet());
        for (int i = this.typeIndexOffset; i < this.typeIndexOffset + 10 && i < typeList.size(); ++i) {
            int j = i - this.typeIndexOffset;
            int k = left + j % 10 * 16;
            int l = j / 10;
            int i1 = top + l * 18 + 2;
            ResourceLocation type = (ResourceLocation)typeList.get(i);
            if (ModBlocks.getInstance().getOrComputeItemGroups().get(type).isEmpty()) {
                DomumOrnamentum.LOGGER.error("Empty Item Category: " + String.valueOf(type));
                continue;
            }
            graphics.renderItem(ModBlocks.getInstance().getOrComputeItemGroups().get(typeList.get(i)).get(0), k, i1);
        }
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null) {
            List<ItemStack> list = ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.menu).getCurrentGroup());
            for (int i = this.recipeIndexOffset; i < this.recipeIndexOffset + 10 && i < list.size(); ++i) {
                int j = i - this.recipeIndexOffset;
                int k = left + j % 10 * 16;
                int l = j / 10;
                int i1 = top + 23 + l * 18 + 2;
                if (((ArchitectsCutterContainer)this.menu).outputInventorySlot.hasItem()) {
                    ItemStack input = list.get(i).copy();
                    this.texturizeVariantUsingCurrentInput(input);
                    graphics.renderItem(input, k, i1);
                    continue;
                }
                graphics.renderItem(list.get(i), k, i1);
            }
        }
    }

    private void texturizeVariantUsingCurrentInput(ItemStack variantItemStack) {
        BlockItem bi;
        Item item = variantItemStack.getItem();
        if (!(item instanceof BlockItem) || !((item = (bi = (BlockItem)item).getBlock()) instanceof IMateriallyTexturedBlock)) {
            return;
        }
        IMateriallyTexturedBlock block = (IMateriallyTexturedBlock)item;
        MaterialTextureData.Builder textureData = MaterialTextureData.builder();
        int i = 0;
        for (IMateriallyTexturedBlockComponent component : block.getComponents()) {
            Item item2 = ((ArchitectsCutterContainer)this.menu).inputInventory.getItem(i).getItem();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                textureData.setComponent(component.getId(), blockItem.getBlock());
            }
            ++i;
        }
        textureData.writeToItemStack(variantItemStack);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double mouseYOffset;
        double mouseXOffset;
        int rowIndex;
        int index;
        int scrollOffset;
        int topOffset;
        int leftOffset;
        this.clickedOnRecipeScroll = false;
        this.clickedOnTypeScroll = false;
        if (((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null) {
            leftOffset = this.leftPos + 57 + 1;
            topOffset = this.topPos + 16 + 23;
            scrollOffset = this.recipeIndexOffset + 10;
            for (index = this.recipeIndexOffset; index < scrollOffset; ++index) {
                rowIndex = index - this.recipeIndexOffset;
                mouseXOffset = mouseX - (double)(leftOffset + rowIndex % 10 * 16);
                mouseYOffset = mouseY - (double)(topOffset + rowIndex / 10 * 18);
                if (!(mouseXOffset >= 0.0) || !(mouseYOffset >= 0.0) || !(mouseXOffset < 16.0) || !(mouseYOffset < 18.0) || !((ArchitectsCutterContainer)this.menu).clickMenuButton((Player)Objects.requireNonNull(Objects.requireNonNull(this.minecraft).player), index + ModBlocks.getInstance().itemGroups.size())) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                Objects.requireNonNull(this.minecraft.gameMode).handleInventoryButtonClick(((ArchitectsCutterContainer)this.menu).containerId, index + ModBlocks.getInstance().itemGroups.size());
                variantIndexCache = index + ModBlocks.getInstance().itemGroups.size();
                return true;
            }
            leftOffset = this.leftPos + 220;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 18)) {
                this.clickedOnRecipeScroll = true;
            }
        }
        if (!this.clickedOnRecipeScroll) {
            leftOffset = this.leftPos + 57 + 1;
            topOffset = this.topPos + 16;
            scrollOffset = this.typeIndexOffset + 10;
            for (index = this.typeIndexOffset; index < scrollOffset; ++index) {
                rowIndex = index - this.typeIndexOffset;
                mouseXOffset = mouseX - (double)(leftOffset + rowIndex % 10 * 16);
                mouseYOffset = mouseY - (double)(topOffset + rowIndex / 10 * 18);
                if (!(mouseXOffset >= 0.0) || !(mouseYOffset >= 0.0) || !(mouseXOffset < 16.0) || !(mouseYOffset < 18.0) || !((ArchitectsCutterContainer)this.menu).clickMenuButton((Player)Objects.requireNonNull(Objects.requireNonNull(this.minecraft).player), index)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                Objects.requireNonNull(this.minecraft.gameMode).handleInventoryButtonClick(((ArchitectsCutterContainer)this.menu).containerId, index);
                groupIndexCache = index;
                this.recipeIndexOffset = 0;
                this.recipeSliderProgress = 0.0f;
                return true;
            }
            leftOffset = this.leftPos + 220;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 18)) {
                this.clickedOnTypeScroll = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnRecipeScroll && this.canScrollRecipes()) {
            int i = this.topPos + 16 + 23;
            int j = i + 10;
            this.recipeSliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 5.0f);
            this.recipeSliderProgress = Mth.clamp((float)this.recipeSliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.recipeSliderProgress * (float)this.getHiddenRecipeRows()) + 0.5) * 10;
            return true;
        }
        if (this.clickedOnTypeScroll && this.canScrollTypes()) {
            int i = this.topPos + 16;
            int j = i + 10;
            this.typeSliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 5.0f);
            this.typeSliderProgress = Mth.clamp((float)this.typeSliderProgress, (float)0.0f, (float)1.0f);
            this.typeIndexOffset = (int)((double)(this.typeSliderProgress * (float)this.getHiddenTypeRows()) + 0.5) * 10;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int i;
        boolean onlyTypes = false;
        if (mouseX >= (double)(this.leftPos + 55) && mouseY >= (double)(this.topPos + 15) && mouseX < (double)(this.leftPos + 220) && mouseY < (double)(this.topPos + 35)) {
            onlyTypes = true;
        }
        boolean onlyRecipes = false;
        if (mouseX >= (double)(this.leftPos + 55) && mouseY >= (double)(this.topPos + 40) && mouseX < (double)(this.leftPos + 220) && mouseY < (double)(this.topPos + 60)) {
            onlyRecipes = true;
        }
        if (this.canScrollRecipes() && !onlyTypes) {
            i = this.getHiddenRecipeRows();
            this.recipeSliderProgress = (float)((double)this.recipeSliderProgress - deltaY / (double)i);
            this.recipeSliderProgress = Mth.clamp((float)this.recipeSliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.recipeSliderProgress * (float)i) + 0.5) * 10;
        }
        if (this.canScrollTypes() && !onlyRecipes) {
            i = this.getHiddenTypeRows();
            this.typeSliderProgress = (float)((double)this.typeSliderProgress - deltaY / (double)i);
            this.typeSliderProgress = Mth.clamp((float)this.typeSliderProgress, (float)0.0f, (float)1.0f);
            this.typeIndexOffset = (int)((double)(this.typeSliderProgress * (float)i) + 0.5) * 10;
        }
        return true;
    }

    private boolean canScrollRecipes() {
        return ((ArchitectsCutterContainer)this.menu).getCurrentGroup() != null && ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.menu).getCurrentGroup()).size() > 10;
    }

    private boolean canScrollTypes() {
        return ModBlocks.getInstance().getOrComputeItemGroups().size() > 10;
    }

    protected int getHiddenRecipeRows() {
        return ((ArchitectsCutterContainer)this.menu).getCurrentGroup() == null ? 0 : (ModBlocks.getInstance().getOrComputeItemGroups().get(((ArchitectsCutterContainer)this.menu).getCurrentGroup()).size() + 10 - 1) / 10 - 1;
    }

    protected int getHiddenTypeRows() {
        return (ModBlocks.getInstance().getOrComputeItemGroups().size() + 10 - 1) / 10 - 1;
    }
}

