/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemCaliper
extends AbstractItemWithPosSelector {
    private static final String ITEM_CALIPER_MESSAGE_XD = "item.caliper.message.%sd";

    public ItemCaliper() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)((Object)ModItems.caliper.get());
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (!worldIn.isClientSide) {
            return InteractionResult.FAIL;
        }
        this.handlePlayerMessage(start, end, playerIn);
        return InteractionResult.SUCCESS;
    }

    private void handlePlayerMessage(BlockPos start, BlockPos end, Player playerIn) {
        int disX = Math.abs(end.getX() - start.getX());
        int disY = Math.abs(end.getY() - start.getY());
        int disZ = Math.abs(end.getZ() - start.getZ());
        ArrayList<Integer> distances = new ArrayList<Integer>();
        if (disX != 0) {
            distances.add(disX + 1);
        }
        if (disY != 0) {
            distances.add(disY + 1);
        }
        if (disZ != 0) {
            distances.add(disZ + 1);
        }
        playerIn.displayClientMessage((Component)Component.translatable((String)String.format(ITEM_CALIPER_MESSAGE_XD, distances.size()), (Object[])distances.toArray(new Object[0])), false);
    }
}

