/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.client.gui.WindowTagTool;
import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTagTool
extends AbstractItemWithPosSelector {
    public ItemTagTool() {
        this(new Item.Properties().durability(0).setNoRepair().rarity(Rarity.UNCOMMON).component(ModDataComponents.TAGS_DATA, (Object)TagData.EMPTY));
    }

    public ItemTagTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)((Object)ModItems.tagTool.get());
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (worldIn.isClientSide) {
            TagData tagData = TagData.readFromItemStack(itemStack);
            if (tagData.anchorPos().isEmpty()) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.noanchor"), false);
                return InteractionResult.FAIL;
            }
            WindowTagTool window = new WindowTagTool(tagData.currentTag().orElse(""), tagData.anchorPos().get(), worldIn, itemStack);
            window.open();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return new InteractionResultHolder(this.onAirRightClick(null, null, worldIn, playerIn, playerIn.getItemInHand(handIn)), (Object)playerIn.getItemInHand(handIn));
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.SUCCESS;
        }
        if (context.getPlayer().isShiftKeyDown()) {
            BlockEntity te = context.getLevel().getBlockEntity(context.getClickedPos());
            if (te instanceof IBlueprintDataProviderBE) {
                TagData.updateItemStack(context.getItemInHand(), tags -> tags.setAnchorPos(context.getClickedPos()));
                if (context.getLevel().isClientSide()) {
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.anchorsaved"), false);
                }
                return InteractionResult.SUCCESS;
            }
            if (context.getLevel().isClientSide()) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.anchor.notvalid"), false);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != ModItems.tagTool.get()) {
            return false;
        }
        TagData tagData = TagData.readFromItemStack(stack);
        if (tagData.anchorPos().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.noanchor"), false);
            return false;
        }
        if (tagData.currentTag().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.notag"), false);
            return false;
        }
        BlockPos anchorPos = tagData.anchorPos().get();
        String currentTag = tagData.currentTag().get();
        BlockPos relativePos = pos.subtract((Vec3i)anchorPos);
        BlockEntity te = worldIn.getBlockEntity(anchorPos);
        if (!(te instanceof IBlueprintDataProviderBE)) {
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.anchor.notvalid"), false);
            TagData.updateItemStack(stack, tags -> tags.setAnchorPos(null));
            return false;
        }
        IBlueprintDataProviderBE blueprintBe = (IBlueprintDataProviderBE)te;
        Map<BlockPos, List<String>> tagPosMap = blueprintBe.getPositionedTags();
        if (!tagPosMap.containsKey(relativePos) || !tagPosMap.get(relativePos).contains(currentTag)) {
            blueprintBe.addTag(relativePos, currentTag);
            if (worldIn.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.addtag", (Object[])new Object[]{currentTag, worldIn.getBlockState(pos).getBlock().getName()}), false);
            }
        } else {
            blueprintBe.removeTag(relativePos, currentTag);
            if (worldIn.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.tagtool.removed", (Object[])new Object[]{currentTag, worldIn.getBlockState(pos).getBlock().getName()}), false);
            }
        }
        return false;
    }

    public record TagData(Optional<BlockPos> anchorPos, Optional<String> currentTag) {
        public static final TagData EMPTY = new TagData(Optional.empty(), Optional.empty());
        public static final Codec<TagData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.optionalFieldOf("anchor_pos_tag").forGetter(TagData::anchorPos), (App)Codec.STRING.optionalFieldOf("current_tag").forGetter(TagData::currentTag)).apply((Applicative)builder, TagData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TagData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), TagData::anchorPos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), TagData::currentTag, TagData::new);

        public TagData setAnchorPos(BlockPos pos) {
            return new TagData(Optional.ofNullable(pos), this.currentTag);
        }

        public TagData setCurrentTag(String currentTag) {
            return new TagData(this.anchorPos, Optional.ofNullable(currentTag.isEmpty() ? null : currentTag));
        }

        public void writeToItemStack(ItemStack itemStack) {
            itemStack.set(ModDataComponents.TAGS_DATA, (Object)this);
        }

        public static TagData readFromItemStack(ItemStack itemStack) {
            return (TagData)itemStack.getOrDefault(ModDataComponents.TAGS_DATA, (Object)EMPTY);
        }

        public static void updateItemStack(ItemStack itemStack, UnaryOperator<TagData> updater) {
            ((TagData)updater.apply(TagData.readFromItemStack(itemStack))).writeToItemStack(itemStack);
        }
    }
}

