/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructureIterators;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StructurePlacer {
    protected final AbstractBlueprintIterator iterator;
    protected final IStructureHandler handler;

    public StructurePlacer(IStructureHandler handler) {
        this.iterator = StructureIterators.getIterator(((String)((ServerConfiguration)Structurize.getConfig().getServer()).iteratorType.get()).toString(), handler);
        this.handler = handler;
    }

    public StructurePlacer(IStructureHandler handler, String id) {
        this.iterator = StructureIterators.getIterator(id, handler);
        this.handler = handler;
    }

    public StructurePlacer(IStructureHandler handler, AbstractBlueprintIterator iterator) {
        this.handler = handler;
        this.iterator = iterator;
        iterator.reset();
    }

    public StructurePhasePlacementResult executeStructureStep(Level world, ChangeStorage storage, BlockPos inputPos, Operation operation, Supplier<AbstractBlueprintIterator.Result> iterateFunction, boolean includeEntities) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        if (includeEntities) {
            this.iterator.includeEntities();
        }
        this.iterator.setProgressPos(new BlockPos(inputPos.getX(), inputPos.getY(), inputPos.getZ()));
        AbstractBlueprintIterator.Result iterationResult = iterateFunction.get();
        BlockPos lastPos = inputPos;
        int count = 0;
        while (iterationResult == AbstractBlueprintIterator.Result.NEW_BLOCK) {
            BlockPlacementResult result;
            BlockPos localPos = this.iterator.getProgressPos();
            BlockPos worldPos = this.handler.getProgressPosInWorld(localPos);
            lastPos = this.iterator.getPrevProgressPos();
            if (count >= this.handler.getStepsPerCall()) {
                return new StructurePhasePlacementResult(lastPos, new BlockPlacementResult(worldPos, BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
            }
            BlockState localState = this.handler.getBluePrint().getBlockState(localPos);
            if (localState == null || world.isOutsideBuildHeight(worldPos)) {
                iterationResult = iterateFunction.get();
                continue;
            }
            if (storage != null) {
                storage.addPreviousDataFor(worldPos, world);
            }
            switch (operation.ordinal()) {
                case 1: {
                    if (!this.handler.isCreative() && !(world.getBlockState(worldPos).getBlock() instanceof AirBlock)) {
                        result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
                        break;
                    }
                    world.removeBlock(worldPos, false);
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case 0: {
                    BlockState worldState = world.getBlockState(worldPos);
                    if (worldState.getBlock() instanceof BucketPickup || BlockUtils.isLiquidOnlyBlock(worldState.getBlock()) || !worldState.getFluidState().isEmpty()) {
                        BlockUtils.removeFluid(world, worldPos);
                    }
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case 3: {
                    result = this.getResourceRequirements(world, worldPos, localPos, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                    requiredItems.addAll(result.getRequiredItems());
                    break;
                }
                case 4: {
                    result = this.handleEntitySpawn(world, worldPos, localPos, storage);
                    break;
                }
                default: {
                    result = this.handleBlockPlacement(world, worldPos, localPos, storage, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                }
            }
            ++count;
            if (storage != null) {
                storage.addPostDataFor(worldPos, world);
            }
            if (operation != Operation.GET_RES_REQUIREMENTS && (result.getResult() == BlockPlacementResult.Result.MISSING_ITEMS || result.getResult() == BlockPlacementResult.Result.FAIL || result.getResult() == BlockPlacementResult.Result.BREAK_BLOCK)) {
                return new StructurePhasePlacementResult(lastPos, result);
            }
            lastPos = localPos;
            iterationResult = iterateFunction.get();
            if (operation == Operation.GET_RES_REQUIREMENTS || count < this.handler.getStepsPerCall()) continue;
            return new StructurePhasePlacementResult(lastPos, result);
        }
        if (iterationResult == AbstractBlueprintIterator.Result.AT_END) {
            this.iterator.reset();
            return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.iterator.getProgressPos(), BlockPlacementResult.Result.FINISHED, requiredItems));
        }
        return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.handler.getProgressPosInWorld(this.iterator.getProgressPos()), BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
    }

    public BlockPlacementResult handleBlockPlacement(Level world, BlockPos worldPos, BlockPos localPos, ChangeStorage storage, BlockState localState, CompoundTag tileEntityData) {
        BlockState worldState = world.getBlockState(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.getBlock() == localState.getBlock() && tileEntityData == null) {
            sameBlockInWorld = true;
        }
        if (!(worldState.getBlock() instanceof AirBlock) && !this.handler.allowReplace()) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
        }
        for (CompoundTag compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().subtract((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.by((CompoundTag)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).create(world)) == null) continue;
                entity.load(compound);
                entity.setUUID(UUID.randomUUID());
                Vec3 posInWorld = entity.position().add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (entity instanceof HangingEntity) {
                    HangingEntity hang = (HangingEntity)entity;
                    posInWorld = posInWorld.subtract(Vec3.atLowerCornerOf((Vec3i)hang.blockPosition().subtract((Vec3i)hang.getPos())));
                }
                entity.moveTo(posInWorld.x, posInWorld.y, posInWorld.z, entity.getYRot(), entity.getXRot());
                List list = world.getEntitiesOfClass(entity.getClass(), new AABB(posInWorld.add(1.0, 1.0, 1.0), posInWorld.add(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.position().equals((Object)posInWorld)) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity || entity instanceof Mob && !this.handler.isCreative()) continue;
                List<ItemStack> requiredItems = ItemStackUtils.getListOfStackForEntity(entity);
                if (!this.handler.isCreative()) {
                    if (requiredItems == null) continue;
                    if (!this.handler.hasRequiredItems(requiredItems)) {
                        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                    }
                } else if (requiredItems == null) {
                    requiredItems = new ArrayList<ItemStack>();
                }
                world.addFreshEntity(entity);
                if (storage != null) {
                    storage.addToBeKilledEntity(entity);
                }
                this.handler.consume(requiredItems);
                this.handler.triggerEntitySuccess(localPos, requiredItems, true);
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        BlockEntity worldEntity = null;
        if (tileEntityData != null) {
            worldEntity = world.getBlockEntity(worldPos);
        }
        if (localState.getBlock() == ModBlocks.blockSolidSubstitution.get() && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos, this.handler.getBluePrint().getRawBlockStateFunction().compose(this.handler::getStructurePosFromWorld));
        }
        if (localState.getBlock() == ModBlocks.blockTagSubstitution.get() && this.handler.fancyPlacement()) {
            BlockEntity blockEntity;
            if (tileEntityData != null && (blockEntity = BlockEntity.loadStatic((BlockPos)localPos, (BlockState)localState, (CompoundTag)tileEntityData, (HolderLookup.Provider)world.registryAccess())) instanceof BlockEntityTagSubstitution) {
                BlockEntityTagSubstitution tagEntity = (BlockEntityTagSubstitution)blockEntity;
                localState = tagEntity.getReplacement().blockState();
                tileEntityData = tagEntity.getReplacement().serializedBE().orElseGet(CompoundTag::new);
            } else {
                localState = Blocks.AIR.defaultBlockState();
            }
        }
        if (BlockUtils.areBlockStatesEqual(localState, worldState, this.handler::replaceWithSolidBlock, this.handler.fancyPlacement(), this.handler::shouldBlocksBeConsideredEqual, tileEntityData, worldEntity)) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
            if (!sameBlockInWorld && !this.handler.isCreative()) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.isEmpty() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
                if (!this.handler.hasRequiredItems(requiredItems)) {
                    return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                }
            }
            if (!(worldState.getBlock() instanceof AirBlock || sameBlockInWorld || worldState.isAir() || worldState.getBlock() instanceof DoublePlantBlock && ((DoubleBlockHalf)worldState.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER))) {
                placementHandler.handleRemoval(this.handler, world, worldPos, tileEntityData);
            }
            this.handler.prePlacementLogic(worldPos, localState, requiredItems);
            IPlacementHandler.ActionProcessingResult result = placementHandler.handle(this.getHandler().getBluePrint(), world, worldPos, localState, tileEntityData, !this.handler.fancyPlacement(), this.handler.getWorldPos(), this.handler.getRotationMirror());
            if (result == IPlacementHandler.ActionProcessingResult.DENY) {
                placementHandler.handleRemoval(this.handler, world, worldPos, tileEntityData);
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
            }
            this.handler.triggerSuccess(localPos, requiredItems, true);
            if (result == IPlacementHandler.ActionProcessingResult.PASS) {
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
            }
            if (!this.handler.isCreative() && !sameBlockInWorld) {
                this.handler.consume(requiredItems);
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
    }

    public BlockPlacementResult handleEntitySpawn(Level world, BlockPos worldPos, BlockPos localPos, ChangeStorage storage) {
        for (CompoundTag compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().subtract((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.by((CompoundTag)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).create(world)) == null) continue;
                entity.load(compound);
                entity.setUUID(UUID.randomUUID());
                Vec3 posInWorld = entity.position().add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (entity instanceof HangingEntity) {
                    HangingEntity hang = (HangingEntity)entity;
                    posInWorld = posInWorld.subtract(Vec3.atLowerCornerOf((Vec3i)hang.blockPosition().subtract((Vec3i)hang.getPos())));
                }
                entity.moveTo(posInWorld.x, posInWorld.y, posInWorld.z, entity.getYRot(), entity.getXRot());
                List list = world.getEntitiesOfClass(entity.getClass(), new AABB(posInWorld.add(1.0, 1.0, 1.0), posInWorld.add(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.position().equals((Object)posInWorld)) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity || entity instanceof Mob && !this.handler.isCreative() || entity instanceof Display.TextDisplay && (!this.handler.isCreative() || this.handler.fancyPlacement())) continue;
                List<ItemStack> requiredItems = ItemStackUtils.getListOfStackForEntity(entity);
                if (!this.handler.isCreative()) {
                    if (requiredItems == null) continue;
                    if (!this.handler.hasRequiredItems(requiredItems)) {
                        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                    }
                } else if (requiredItems == null) {
                    requiredItems = new ArrayList<ItemStack>();
                }
                world.addFreshEntity(entity);
                if (storage != null) {
                    storage.addToBeKilledEntity(entity);
                }
                this.handler.consume(requiredItems);
                this.handler.triggerEntitySuccess(localPos, requiredItems, true);
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
    }

    public StructurePhasePlacementResult clearWaterStep(Level world, BlockPos inputPos) {
        BlockPos size = this.iterator.getSize();
        int yLayer = inputPos.getY() == -1 ? size.getY() - 1 : inputPos.getY();
        for (int x = 0; x < size.getX(); ++x) {
            for (int z = 0; z < size.getZ(); ++z) {
                BucketPickup bucketpickup;
                Block block;
                BlockPos worldPos;
                BlockState worldState;
                FluidState fluidState;
                BlockPos localPos = new BlockPos(x, yLayer, z);
                BlockState localState = this.iterator.getBluePrintPositionInfo(localPos).getBlockInfo().getState();
                if (!localState.getFluidState().isEmpty() || localState.getBlock() == ModBlocks.blockSubstitution.get() || localState.getBlock() == ModBlocks.blockFluidSubstitution.get() || (fluidState = (worldState = world.getBlockState(worldPos = this.handler.getProgressPosInWorld(localPos))).getFluidState()).isEmpty() || (block = worldState.getBlock()) instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)world, worldPos, worldState).isEmpty()) continue;
                if (worldState.getBlock() instanceof LiquidBlock) {
                    world.setBlock(worldPos, Blocks.AIR.defaultBlockState(), 3);
                    continue;
                }
                if (!worldState.is(Blocks.KELP) && !worldState.is(Blocks.KELP_PLANT) && !worldState.is(Blocks.SEAGRASS) && !worldState.is(Blocks.TALL_SEAGRASS)) continue;
                BlockEntity blockentity = worldState.hasBlockEntity() ? world.getBlockEntity(worldPos) : null;
                Block.dropResources((BlockState)worldState, (LevelAccessor)world, (BlockPos)worldPos, (BlockEntity)blockentity);
                world.setBlock(worldPos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        BlockPos progressPos = new BlockPos(0, yLayer, 0);
        if (yLayer <= 0) {
            return new StructurePhasePlacementResult(progressPos.below(), new BlockPlacementResult(this.handler.getProgressPosInWorld(progressPos), BlockPlacementResult.Result.FINISHED));
        }
        return new StructurePhasePlacementResult(progressPos.below(), new BlockPlacementResult(this.handler.getProgressPosInWorld(progressPos.below()), BlockPlacementResult.Result.SUCCESS));
    }

    public BlockPlacementResult getResourceRequirements(Level world, BlockPos worldPos, BlockPos localPos, BlockState localState, CompoundTag tileEntityData) {
        BlockState worldState = world.getBlockState(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.getBlock() == localState.getBlock() && tileEntityData == null) {
            sameBlockInWorld = true;
        }
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        for (CompoundTag compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().subtract((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.by((CompoundTag)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).create(world)) == null) continue;
                entity.load(compound);
                Vec3 posInWorld = entity.position().add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                List list = world.getEntitiesOfClass(entity.getClass(), new AABB(posInWorld.add(1.0, 1.0, 1.0), posInWorld.add(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.position().equals((Object)posInWorld)) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity) continue;
                requiredItems.addAll(ItemStackUtils.getListOfStackForEntity(entity));
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        BlockEntity worldEntity = null;
        if (tileEntityData != null) {
            worldEntity = world.getBlockEntity(worldPos);
        }
        if (localState.getBlock() == ModBlocks.blockSolidSubstitution.get() && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos, this.handler.getBluePrint().getRawBlockStateFunction().compose(this.handler::getStructurePosFromWorld));
        }
        if (localState.getBlock() == ModBlocks.blockTagSubstitution.get() && this.handler.fancyPlacement()) {
            BlockEntity blockEntity;
            if (tileEntityData != null && (blockEntity = BlockEntity.loadStatic((BlockPos)localPos, (BlockState)localState, (CompoundTag)tileEntityData, (HolderLookup.Provider)world.registryAccess())) instanceof BlockEntityTagSubstitution) {
                BlockEntityTagSubstitution tagEntity = (BlockEntityTagSubstitution)blockEntity;
                localState = tagEntity.getReplacement().blockState();
                tileEntityData = tagEntity.getReplacement().serializedBE().orElseGet(CompoundTag::new);
            } else {
                localState = Blocks.AIR.defaultBlockState();
            }
        }
        if (BlockUtils.areBlockStatesEqual(localState, worldState, this.handler::replaceWithSolidBlock, this.handler.fancyPlacement(), this.handler::shouldBlocksBeConsideredEqual, tileEntityData, worldEntity)) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            if (!sameBlockInWorld) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.isEmpty() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
    }

    public AbstractBlueprintIterator getIterator() {
        return this.iterator;
    }

    public IStructureHandler getHandler() {
        return this.handler;
    }

    public boolean isReady() {
        return this.getHandler().isReady();
    }

    public static enum Operation {
        WATER_REMOVAL,
        BLOCK_REMOVAL,
        BLOCK_PLACEMENT,
        GET_RES_REQUIREMENTS,
        SPAWN_ENTITY;

    }
}

