/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryUtils {
    public static boolean hasRequiredItems(IItemHandler inventory, List<ItemStack> requiredItems) {
        ArrayList<ItemStack> listToDiscount = new ArrayList<ItemStack>();
        for (ItemStack stack : requiredItems) {
            listToDiscount.add(stack.copy());
        }
        block1: for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack content = inventory.getStackInSlot(slot);
            if (content.isEmpty()) continue;
            int contentCount = content.getCount();
            for (ItemStack stack : listToDiscount) {
                if (stack.isEmpty() || !ItemStackUtils.compareItemStacksIgnoreStackSize(stack, content)) continue;
                if (stack.getCount() < content.getCount()) {
                    contentCount -= stack.getCount();
                    stack.setCount(0);
                    continue;
                }
                stack.setCount(stack.getCount() - contentCount);
                continue block1;
            }
        }
        for (ItemStack stack : listToDiscount) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void transferIntoNextBestSlot(ItemStack stack, IItemHandler targetHandler) {
        if (stack.isEmpty()) {
            return;
        }
        ItemStack sourceStack = stack.copy();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (!(sourceStack = targetHandler.insertItem(i, sourceStack, false)).isEmpty()) continue;
            return;
        }
    }

    public static void consumeStack(ItemStack tempStack, IItemHandler handler) {
        int count = tempStack.getCount();
        ItemStack container = tempStack.getCraftingRemainingItem();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(handler.getStackInSlot(i), tempStack)) continue;
            ItemStack result = handler.extractItem(i, count, false);
            if (result.getCount() == count) {
                if (!container.isEmpty()) {
                    for (int j = 0; j < tempStack.getCount(); ++j) {
                        InventoryUtils.transferIntoNextBestSlot(container, handler);
                    }
                }
                return;
            }
            count -= result.getCount();
        }
    }
}

