/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.dynresources;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.util.ForwardingInclDefaultsMap;
import org.jetbrains.annotations.Nullable;

public class ModelBakeEventHelper {
    private static final Set<String> INCOMPATIBLE_MODS = ImmutableSet.of((Object)"industrialforegoing", (Object)"mekanism", (Object)"vampirism", (Object)"elevatorid", (Object)"cfm", (Object)"refinedstorage", (Object[])new String[]{"embers"});
    private final Map<ModelResourceLocation, BakedModel> modelRegistry;
    private final Set<ModelResourceLocation> topLevelModelLocations;
    private final MutableGraph<String> dependencyGraph;
    private static final Set<String> WARNED_MOD_IDS = new HashSet<String>();

    public ModelBakeEventHelper(Map<ModelResourceLocation, BakedModel> modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.topLevelModelLocations = new HashSet<ModelResourceLocation>(modelRegistry.keySet());
        BuiltInRegistries.BLOCK.entrySet().forEach(entry -> {
            ResourceLocation location = ((ResourceKey)entry.getKey()).location();
            for (BlockState state : ((Block)entry.getValue()).getStateDefinition().getPossibleStates()) {
                this.topLevelModelLocations.add(BlockModelShaper.stateToModelLocation((ResourceLocation)location, (BlockState)state));
            }
        });
        BuiltInRegistries.ITEM.keySet().forEach(location -> this.topLevelModelLocations.add(new ModelResourceLocation(location, "inventory")));
        this.dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            this.dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                this.dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : this.dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                this.dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
    }

    private Map<ModelResourceLocation, BakedModel> createWarningRegistry(final String modId) {
        return new ForwardingInclDefaultsMap<ModelResourceLocation, BakedModel>(){

            protected Map<ModelResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            private void logWarning() {
                if (!WARNED_MOD_IDS.add(modId)) {
                    return;
                }
                ModernFix.LOGGER.warn("Mod '{}' is accessing Map#keySet/entrySet/values/replaceAll on the model registry map inside its event handler. This probably won't work as expected with dynamic resources on. Prefer using Map#get/put and constructing ModelResourceLocations another way.", (Object)modId);
            }

            public Set<ModelResourceLocation> keySet() {
                this.logWarning();
                return super.keySet();
            }

            public Set<Map.Entry<ModelResourceLocation, BakedModel>> entrySet() {
                this.logWarning();
                return super.entrySet();
            }

            public Collection<BakedModel> values() {
                this.logWarning();
                return super.values();
            }

            @Override
            public void replaceAll(BiFunction<? super ModelResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
                this.logWarning();
                super.replaceAll(function);
            }
        };
    }

    public Map<ModelResourceLocation, BakedModel> wrapRegistry(final String modId) {
        final HashSet<String> modIdsToInclude = new HashSet<String>();
        modIdsToInclude.add(modId);
        try {
            modIdsToInclude.addAll(this.dependencyGraph.adjacentNodes((Object)modId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modIdsToInclude.remove("minecraft");
        if (modIdsToInclude.stream().noneMatch(INCOMPATIBLE_MODS::contains)) {
            return this.createWarningRegistry(modId);
        }
        final Set ourModelLocations = Sets.filter(this.topLevelModelLocations, loc -> modIdsToInclude.contains(loc.id().getNamespace()));
        final BakedModel missingModel = this.modelRegistry.get(ModelBakery.MISSING_MODEL_VARIANT);
        return new ForwardingMap<ModelResourceLocation, BakedModel>(){

            protected Map<ModelResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            public BakedModel get(@Nullable Object key) {
                BakedModel model = (BakedModel)super.get(key);
                if (model == null && key != null && modIdsToInclude.contains(((ResourceLocation)key).getNamespace())) {
                    ModernFix.LOGGER.warn("Model {} is missing, but was requested in model bake event. Returning missing model", key);
                    return missingModel;
                }
                return model;
            }

            public Set<ModelResourceLocation> keySet() {
                return ourModelLocations;
            }

            public boolean containsKey(@Nullable Object key) {
                return ourModelLocations.contains(key) || super.containsKey(key);
            }

            public Set<Map.Entry<ModelResourceLocation, BakedModel>> entrySet() {
                return new DynamicModelEntrySet((Map<ModelResourceLocation, BakedModel>)((Object)this), ourModelLocations);
            }

            public void replaceAll(BiFunction<? super ModelResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
                ModernFix.LOGGER.warn("Mod '{}' is calling replaceAll on the model registry. Some hacks will be used to keep this fast, but they may not be 100% compatible.", (Object)modId);
                ArrayList<ModelResourceLocation> locations = new ArrayList<ModelResourceLocation>(this.keySet());
                for (ModelResourceLocation location : locations) {
                    BakedModel existing;
                    BakedModel replacement;
                    boolean needsReplacement;
                    try {
                        needsReplacement = function.apply((ModelResourceLocation)location, null) != null;
                    }
                    catch (Throwable e) {
                        needsReplacement = true;
                    }
                    if (!needsReplacement || (replacement = function.apply((ModelResourceLocation)location, (BakedModel)(existing = this.get(location)))) == existing) continue;
                    this.put(location, replacement);
                }
            }
        };
    }

    private static class DynamicModelEntrySet
    extends AbstractSet<Map.Entry<ModelResourceLocation, BakedModel>> {
        private final Map<ModelResourceLocation, BakedModel> modelRegistry;
        private final Set<ModelResourceLocation> modelLocations;

        private DynamicModelEntrySet(Map<ModelResourceLocation, BakedModel> modelRegistry, Set<ModelResourceLocation> modelLocations) {
            this.modelRegistry = modelRegistry;
            this.modelLocations = modelLocations;
        }

        @Override
        public Iterator<Map.Entry<ModelResourceLocation, BakedModel>> iterator() {
            return Iterators.transform((Iterator)Iterators.unmodifiableIterator(this.modelLocations.iterator()), x$0 -> new DynamicModelEntry((ModelResourceLocation)x$0));
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.modelRegistry.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public int size() {
            return this.modelRegistry.size();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        private class DynamicModelEntry
        implements Map.Entry<ModelResourceLocation, BakedModel> {
            private final ModelResourceLocation location;

            private DynamicModelEntry(ModelResourceLocation location) {
                this.location = location;
            }

            @Override
            public ModelResourceLocation getKey() {
                return this.location;
            }

            @Override
            public BakedModel getValue() {
                return DynamicModelEntrySet.this.modelRegistry.get(this.location);
            }

            @Override
            public BakedModel setValue(BakedModel value) {
                return DynamicModelEntrySet.this.modelRegistry.put(this.location, value);
            }
        }
    }
}

