/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.jadecolonies.minecolonies;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.Iterator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class CitizenListComponentProvider
implements IBlockComponentProvider {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jadecolonies", (String)"colony.citizens");
    private static final CitizenListComponentProvider INSTANCE = new CitizenListComponentProvider();

    CitizenListComponentProvider() {
    }

    public static CitizenListComponentProvider getInstance() {
        return INSTANCE;
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    public int getDefaultPriority() {
        return -1000;
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor blockAccessor, @NotNull IPluginConfig pluginConfig) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding entity = (AbstractTileEntityColonyBuilding)blockEntity;
            IBuildingView building = entity.getBuildingView();
            if (building == null) {
                return;
            }
            Iterator iterator = building.getAllAssignedCitizens().iterator();
            while (iterator.hasNext()) {
                int citizenId = (Integer)iterator.next();
                ICitizenDataView citizen = building.getColony().getCitizen(citizenId);
                MutableComponent component = Component.empty();
                if (!citizen.getJob().isEmpty()) {
                    component.append((Component)Component.translatable((String)citizen.getJob()));
                    component.append((Component)Component.literal((String)": "));
                }
                component.append((Component)Component.literal((String)citizen.getName()));
                tooltip.add((Component)component);
            }
        }
    }
}

