/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final ResourceLocation SELECTED = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.color((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.color((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.color((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    @Nullable
    protected final ResourceLocation icon;
    protected final Supplier<Boolean> isSelected;

    public AudioDeviceEntry(String device, String name, @Nullable ResourceLocation icon, Supplier<Boolean> isSelected) {
        this.device = device;
        this.icon = icon;
        this.isSelected = isSelected;
        this.visibleDeviceName = name;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        boolean selected = this.isSelected.get();
        if (selected) {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL);
        }
        if (this.icon != null) {
            guiGraphics.blit(this.icon, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        if (selected) {
            guiGraphics.blit(SELECTED, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        float deviceWidth = this.minecraft.font.width(this.visibleDeviceName);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        guiGraphics.pose().pushPose();
        PoseStack poseStack = guiGraphics.pose();
        double d = left + 4 + 16 + 4;
        float f = top + height / 2;
        Objects.requireNonNull(this.minecraft.font);
        poseStack.translate(d, (double)(f - 9.0f * scale / 2.0f), 0.0);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawString(this.minecraft.font, this.visibleDeviceName, 0, 0, DEVICE_NAME_COLOR, false);
        guiGraphics.pose().popPose();
    }

    public String getDevice() {
        return this.device;
    }
}

