/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class JoinGroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_join_group.png");
    protected static final Component TITLE = Component.translatable((String)"gui.voicechat.join_create_group.title");
    protected static final Component CREATE_GROUP = Component.translatable((String)"message.voicechat.create_group_button");
    protected static final Component JOIN_CREATE_GROUP = Component.translatable((String)"message.voicechat.join_create_group");
    protected static final Component NO_GROUPS = Component.translatable((String)"message.voicechat.no_groups").withStyle(ChatFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected JoinGroupList groupList;
    protected Button createGroup;
    protected int units;

    public JoinGroupScreen() {
        super(TITLE, 236, 0);
    }

    @Override
    protected void init() {
        super.init();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.ceil((float)2.2222223f);
        this.units = Math.max(minUnits, (this.height - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.groupList != null) {
            this.groupList.setRectangle(this.width, this.units * 18, 0, this.guiTop + 16);
        } else {
            this.groupList = new JoinGroupList(this, this.width, this.units * 18, this.guiTop + 16, 36);
        }
        this.addWidget((GuiEventListener)this.groupList);
        this.createGroup = Button.builder((Component)CREATE_GROUP, button -> this.minecraft.setScreen((Screen)new CreateGroupScreen())).bounds(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20).build();
        this.addRenderableWidget((GuiEventListener)this.createGroup);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.blit(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.drawString(this.font, JOIN_CREATE_GROUP, this.guiLeft + this.xSize / 2 - this.font.width((FormattedText)JOIN_CREATE_GROUP) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.groupList.isEmpty()) {
            this.groupList.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            int n = this.width / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, NO_GROUPS, n, n2 - 9 / 2, -1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (JoinGroupEntry entry : this.groupList.children()) {
            if (!entry.isMouseOver(mouseX, mouseY)) continue;
            ClientGroup group = entry.getGroup().getGroup();
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (group.hasPassword()) {
                this.minecraft.setScreen((Screen)new EnterPasswordScreen(group));
            } else {
                ClientServerNetManager.sendToServer(new JoinGroupPacket(group.getId(), null));
            }
            return true;
        }
        return false;
    }
}

