/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import net.minecraft.network.chat.Component;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final Component MUTED = Component.translatable((String)"message.voicechat.muted");
    protected static final float MAXIMUM = 4.0f;
    protected final VolumeConfigEntry volumeConfigEntry;

    public AdjustVolumeSlider(int xIn, int yIn, int widthIn, int heightIn, VolumeConfigEntry volumeConfigEntry) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.value <= 0.0) {
            this.setMessage(MUTED);
            return;
        }
        long amp = Math.round(this.value * 4.0 * 100.0 - 100.0);
        this.setMessage((Component)Component.translatable((String)"message.voicechat.volume_amplification", (Object[])new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}));
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.value * 4.0);
    }

    public static interface VolumeConfigEntry {
        public void save(double var1);

        public double get();
    }
}

