/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ImageButton
extends AbstractButton {
    protected Minecraft mc = Minecraft.getInstance();
    protected ResourceLocation texture;
    @Nullable
    protected PressAction onPress;
    @Nullable
    protected TooltipSupplier tooltipSupplier;

    public ImageButton(int x, int y, ResourceLocation texture, @Nullable PressAction onPress, @Nullable TooltipSupplier tooltipSupplier) {
        super(x, y, 20, 20, (Component)Component.empty());
        this.texture = texture;
        this.onPress = onPress;
        this.tooltipSupplier = tooltipSupplier;
    }

    public ImageButton(int x, int y, ResourceLocation texture, PressAction onPress) {
        this(x, y, texture, onPress, null);
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    protected void renderImage(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.texture, this.getX() + 2, this.getY() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        super.renderWidget(guiGraphics, mouseX, mouseY, f);
        this.renderImage(guiGraphics, mouseX, mouseY);
        if (this.isHovered) {
            this.renderToolTip(guiGraphics, this.mc.font, mouseX, mouseY);
        }
    }

    public void renderToolTip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
        if (this.tooltipSupplier == null) {
            return;
        }
        this.tooltipSupplier.onTooltip(this, guiGraphics, font, mouseX, mouseY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public static interface PressAction {
        public void onPress(ImageButton var1);
    }

    public static interface TooltipSupplier {
        public void onTooltip(ImageButton var1, GuiGraphics var2, Font var3, int var4, int var5);
    }
}

