/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class KeybindButton
extends AbstractButton {
    private static final Minecraft mc = Minecraft.getInstance();
    protected KeyMapping keyMapping;
    @Nullable
    protected Component description;
    protected boolean listening;

    public KeybindButton(KeyMapping mapping, int x, int y, int width, int height, @Nullable Component description) {
        super(x, y, width, height, (Component)Component.empty());
        this.keyMapping = mapping;
        this.description = description;
        this.updateText();
    }

    public KeybindButton(KeyMapping mapping, int x, int y, int width, int height) {
        this(mapping, x, y, width, height, null);
    }

    protected void updateText() {
        MutableComponent text = this.listening ? Component.literal((String)"> ").append((Component)KeybindButton.getText(this.keyMapping).copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).append(" <").withStyle(ChatFormatting.YELLOW) : KeybindButton.getText(this.keyMapping).copy();
        if (this.description != null) {
            text = this.description.copy().append(": ").append((Component)text);
        }
        this.setMessage((Component)text);
    }

    private static Component getText(KeyMapping keyMapping) {
        return keyMapping.getTranslatedKeyMessage();
    }

    public void onPress() {
        this.listening = true;
        this.updateText();
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.listening) {
            KeybindButton.mc.options.setKey(this.keyMapping, InputConstants.Type.MOUSE.getOrCreate(button));
            this.listening = false;
            this.updateText();
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.listening) {
            if (key == 256) {
                KeybindButton.mc.options.setKey(this.keyMapping, InputConstants.UNKNOWN);
            } else {
                KeybindButton.mc.options.setKey(this.keyMapping, InputConstants.getKey((int)key, (int)scanCode));
            }
            this.listening = false;
            this.updateText();
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean keyReleased(int key, int scanCode, int modifiers) {
        if (this.listening && key == 256) {
            return true;
        }
        return super.keyReleased(key, scanCode, modifiers);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isListening() {
        return this.listening;
    }
}

