/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common;

import de.nekeras.borderless.common.glfw.GlfwUtils;
import de.nekeras.borderless.common.mode.FullscreenDisplayMode;
import de.nekeras.borderless.common.spi.ConfigProvider;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullscreenDisplayModeHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FullscreenDisplayModeHolder.class);
    private final ConfigProvider configProvider;
    private final MinecraftWindow window;
    private FullscreenDisplayMode currentMode;

    public void setFullscreenDisplayMode(@Nullable FullscreenDisplayMode newMode) {
        log.info("Detected fullscreen mode change from {} to {}", (Object)this.currentMode, (Object)newMode);
        if (this.currentMode != null) {
            this.currentMode.reset(this.window);
        }
        log.info("Refreshing {}", (Object)newMode);
        if (newMode != null) {
            if (this.window.isFullscreen()) {
                newMode.apply(this.window);
            } else {
                newMode.reset(this.window);
            }
        }
        this.currentMode = newMode;
        GlfwUtils.checkInputMode(this.window);
    }

    public void setFullscreenDisplayModeFromConfig() {
        FullscreenDisplayMode configMode = this.configProvider.getFullscreenDisplayMode();
        log.info("Refreshing fullscreen mode from config to {}", (Object)configMode);
        this.setFullscreenDisplayMode(configMode);
    }

    @Generated
    public FullscreenDisplayModeHolder(ConfigProvider configProvider, MinecraftWindow window) {
        this.configProvider = configProvider;
        this.window = window;
    }
}

