/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common.glfw;

import de.nekeras.borderless.common.glfw.GlfwWindowAttribute;
import de.nekeras.borderless.common.spi.MinecraftMonitor;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlfwUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlfwUtils.class);

    private GlfwUtils() {
    }

    @Nonnull
    public static String getMonitorName(@Nonnull MinecraftMonitor monitor) {
        String name = GLFW.glfwGetMonitorName((long)monitor.getHandle());
        if (name == null) {
            log.warn("Could not retrieve monitor name for {}", (Object)monitor.getHandle());
            return "- ERROR -";
        }
        return name;
    }

    @Nonnull
    public static Optional<MinecraftMonitor> tryGetMonitor(@Nonnull MinecraftWindow window) {
        MinecraftMonitor monitor = window.findBestMonitor();
        if (monitor == null) {
            log.error("Window's current monitor could not be retrieved");
        }
        return Optional.ofNullable(monitor);
    }

    public static void enableWindowAttribute(@Nonnull MinecraftWindow window, @Nonnull GlfwWindowAttribute attribute) {
        log.info("Enable window attribute {}", (Object)attribute.name());
        GLFW.glfwSetWindowAttrib((long)window.getHandle(), (int)attribute.getBit(), (int)1);
    }

    public static void disableWindowAttribute(@Nonnull MinecraftWindow window, @Nonnull GlfwWindowAttribute attribute) {
        log.info("Disable window attribute {}", (Object)attribute.name());
        GLFW.glfwSetWindowAttrib((long)window.getHandle(), (int)attribute.getBit(), (int)0);
    }

    public static void applyDefaultWindowAttributes(@Nonnull MinecraftWindow window) {
        log.info("Resetting window attributes");
        for (GlfwWindowAttribute attribute : GlfwWindowAttribute.values()) {
            if (attribute.isEnabledByDefault()) {
                GlfwUtils.enableWindowAttribute(window, attribute);
                continue;
            }
            GlfwUtils.disableWindowAttribute(window, attribute);
        }
        log.info("Done resetting window attributes");
    }

    public static void checkInputMode(@Nonnull MinecraftWindow window) {
        log.info("Checking window input mode");
        switch (GLFW.glfwGetInputMode((long)window.getHandle(), (int)208897)) {
            case 212993: {
                log.info("Detected normal cursor mode");
                break;
            }
            case 212994: {
                log.info("Detected hidden cursor mode");
                GLFW.glfwSetInputMode((long)window.getHandle(), (int)208897, (int)212993);
                break;
            }
            case 212995: {
                log.info("Detected disabled cursor mode");
                break;
            }
            default: {
                log.info("Unknown cursor mode");
            }
        }
        log.info("Done checking window input mode");
        double[] xPos = new double[1];
        double[] yPos = new double[1];
        GLFW.glfwGetCursorPos((long)window.getHandle(), (double[])xPos, (double[])yPos);
        int x = (int)Math.floor(xPos[0]);
        int y = (int)Math.floor(yPos[0]);
        int winWidth = window.getWidth();
        int winHeight = window.getHeight();
        boolean inside = x >= 0 && x <= winWidth && y >= 0 && y <= winHeight;
        log.info("Cursor is at {}x{} (inside window: {})", new Object[]{x, y, inside});
        log.info("Done checking cursor position");
    }
}

