/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common.reflection;

import de.nekeras.borderless.common.reflection.AccessibleFieldDelegate;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    @Nonnull
    public static <C, F> AccessibleFieldDelegate<C, F> makeFieldAccessible(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldType) {
        try {
            return new AccessibleFieldDelegate<C, F>(inClass, fieldType);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(String.format("Expected field of type %s in class %s", inClass.getName(), fieldType.getName()), e);
        }
    }

    @Nonnull
    public static <C, F> AccessibleFieldDelegate<C, F> tryMakeFieldAccessible(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldType, @Nonnull Function<C, F> defaultSupplier) {
        return new AccessibleFieldDelegate<C, F>(inClass, fieldType, defaultSupplier);
    }

    public static boolean isCalledByGlfwCallback() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getClassName().equals(GLFWFramebufferSizeCallbackI.class.getName()) || e.getClassName().equals(GLFWWindowSizeCallbackI.class.getName()));
    }
}

