/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.platform.Window;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BOWindow
extends View {
    public static final int DEFAULT_WIDTH = 420;
    public static final int DEFAULT_HEIGHT = 240;
    protected BOScreen screen;
    protected boolean windowPausesGame = true;
    protected boolean lightbox = true;
    protected WindowRenderType windowRenderType = WindowRenderType.OVERSIZED_VANILLA;
    protected ResourceLocation xmlResourceLocation;

    public BOWindow(ResourceLocation resource) {
        this();
        this.xmlResourceLocation = resource;
        Loader.createFromXMLFile(resource, this);
    }

    public BOWindow() {
        this(420, 240);
    }

    public BOWindow(int w, int h) {
        this.width = w;
        this.height = h;
        this.screen = new BOScreen(this);
        this.window = this;
    }

    public void loadParams(PaneParams params) {
        params.getResource("inherit", r -> Loader.createFromXMLFile(r, this));
        params.applyShorthand("size", Parsers.INT, 2, a -> {
            this.width = (Integer)a.get(0);
            this.height = (Integer)a.get(1);
        });
        this.lightbox = params.getBoolean("lightbox", this.lightbox);
        this.windowPausesGame = params.getBoolean("pause", this.windowPausesGame);
        this.windowRenderType = params.getEnum("type", WindowRenderType.class, this.windowRenderType);
    }

    @Override
    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
        debugging = Screen.hasShiftDown() && Screen.hasAltDown() && Screen.hasControlDown();
        super.drawSelf(ms, mx, my);
    }

    public boolean hasLightbox() {
        return this.lightbox;
    }

    public boolean doesWindowPauseGame() {
        return this.windowPausesGame;
    }

    public WindowRenderType getRenderType() {
        return this.windowRenderType;
    }

    public ResourceLocation getXmlResourceLocation() {
        return this.xmlResourceLocation;
    }

    public void open() {
        this.mc.submit(() -> this.mc.setScreen((Screen)this.screen));
    }

    public void openAsLayer() {
        this.mc.submit(() -> this.mc.pushGuiLayer((Screen)this.screen));
    }

    public BOScreen getScreen() {
        return this.screen;
    }

    public boolean onMouseReleased(double mx, double my) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (BOWindow.getFocus() != null && BOWindow.getFocus().onKeyTyped(ch, key)) {
            return true;
        }
        return this.onUnhandledKeyTyped(ch, key);
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            if (BOWindow.getFocus() != null) {
                BOWindow.clearFocus();
            } else {
                this.close();
            }
            return true;
        }
        return false;
    }

    public void close() {
        Minecraft.getInstance().popGuiLayer();
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public static enum WindowRenderType {
        VANILLA((mcWindow, window) -> Math.max(mcWindow.getGuiScale(), 1.0)),
        FULLSCREEN((mcWindow, window) -> {
            double widthScale = (double)mcWindow.getScreenWidth() / (double)window.getWidth();
            double heightScale = (double)mcWindow.getScreenHeight() / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FULLSCREEN_VANILLA((mcWindow, window) -> {
            double widthScale = Math.max((double)mcWindow.getScreenWidth(), 320.0) / (double)window.getWidth();
            double heightScale = Math.max((double)mcWindow.getScreenHeight(), 240.0) / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FIXED((mcWindow, window) -> 1.0),
        FIXED_VANILLA((mcWindow, window) -> Math.min(FULLSCREEN_VANILLA.calcRenderScale((Window)mcWindow, (BOWindow)window), 1.0)),
        OVERSIZED((mcWindow, window) -> {
            double fs = FULLSCREEN.calcRenderScale((Window)mcWindow, (BOWindow)window);
            int userScale = (Integer)((BOWindow)window).mc.options.guiScale().get();
            return fs < 1.0 ? fs : Math.min(Math.floor(fs), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        }),
        OVERSIZED_VANILLA((mcWindow, window) -> {
            double fs_vanilla = FULLSCREEN_VANILLA.calcRenderScale((Window)mcWindow, (BOWindow)window);
            int userScale = (Integer)((BOWindow)window).mc.options.guiScale().get();
            return fs_vanilla < 1.0 ? fs_vanilla : Math.min(Math.floor(fs_vanilla), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        });

        private final ToDoubleBiFunction<Window, BOWindow> renderScaleCalculator;

        private WindowRenderType(ToDoubleBiFunction<Window, BOWindow> renderScaleCalculator) {
            this.renderScaleCalculator = renderScaleCalculator;
        }

        public double calcRenderScale(Window mcWindow, BOWindow window) {
            return this.renderScaleCalculator.applyAsDouble(mcWindow, window);
        }
    }
}

