/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.util.records.Pos2i;
import com.ldtteam.blockui.views.OverlayView;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DropDownList
extends View
implements ButtonHandler {
    protected OverlayView overlay;
    protected Button button;
    protected ScrollingList list;
    protected DataProvider dataProvider;
    protected Consumer<DropDownList> handler;
    protected int dropDownWidth;
    protected int dropDownHeight;
    protected int selectedIndex = -1;

    public DropDownList() {
    }

    public DropDownList(PaneParams params) {
        super(params);
        this.dropDownWidth = this.width;
        this.dropDownHeight = this.height;
        params.applyShorthand("dropDownSize", Parsers.INT, 2, a -> {
            this.dropDownWidth = (Integer)a.get(0);
            this.dropDownHeight = (Integer)a.get(1);
        });
        this.button = new ButtonImage(params);
        this.button.setPosition(0, 0);
        this.button.putInside(this);
        this.overlay = new OverlayView();
        this.overlay.setVisible(false);
        this.overlay.setPosition(0, 0);
        this.list = new ScrollingList(params);
        if (params.getInteger("maxContentHeight", 0) != 0) {
            this.list.setMaxHeight(params.getInteger("maxContentHeight", 0));
        }
        this.list.setSize(this.dropDownWidth, this.dropDownHeight);
        this.list.putInside(this.overlay);
        this.list.parseChildren(params);
        this.button.setHandler(this);
    }

    @Override
    public void onButtonClicked(Button buttonIn) {
        if (buttonIn == this.button) {
            if (this.overlay.isVisible()) {
                this.close();
            } else {
                Pos2i.ImmutablePos2i rootPos = this.getAccumulatedPosition();
                this.list.setPosition(rootPos.x() + this.width / 2 - this.dropDownWidth / 2, rootPos.y() + this.height);
                this.overlay.setSize(this.getWindow().getInteriorWidth(), this.getWindow().getInteriorHeight());
                this.overlay.putInside(buttonIn.getWindow());
                this.open();
            }
        } else {
            this.onButtonClickedFromList(buttonIn);
        }
    }

    public void close() {
        this.overlay.setVisible(false);
    }

    public void open() {
        this.refreshElementPanes();
        this.overlay.setVisible(true);
        this.overlay.setFocus();
    }

    private void onButtonClickedFromList(Button buttonIn) {
        int index = this.list.getListElementIndexByPane(buttonIn);
        this.setSelectedIndex(index);
        this.close();
    }

    public void refreshElementPanes() {
        this.list.refreshElementPanes();
        this.list.setSize(this.dropDownWidth, Math.min(this.list.getContentHeight(), this.dropDownHeight));
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.dataProvider.getElementCount()) {
            return;
        }
        this.selectedIndex = index;
        this.button.setText(this.dataProvider.getLabel(this.selectedIndex));
        if (this.handler != null) {
            this.handler.accept(this);
        }
    }

    public void selectPrevious() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + this.dataProvider.getElementCount() - 1) % this.dataProvider.getElementCount());
        }
    }

    public void selectNext() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + 1) % this.dataProvider.getElementCount());
        }
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.list.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return DropDownList.this.dataProvider.getElementCount();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                DropDownList.this.updateDropDownItem(rowPane, index, DropDownList.this.dataProvider.getLabel(index));
            }
        });
        this.refreshElementPanes();
    }

    private void updateDropDownItem(Pane rowPane, int index, MutableComponent label) {
        Button choiceButton = rowPane.findPaneOfTypeByID("button", Button.class);
        if (choiceButton != null) {
            choiceButton.setText(label);
            choiceButton.setHandler(this);
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        this.button.setVisible(v);
        this.list.setVisible(v);
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.button.setEnabled(e);
        this.list.setEnabled(e);
    }

    @Override
    public void parseChildren(PaneParams params) {
    }

    public void setHandler(Consumer<DropDownList> h) {
        this.handler = h;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return super.isPointInPane(mx, my) || this.overlay.shouldDraw() && this.list.isPointInPane(mx, my);
    }

    public static interface DataProvider {
        public int getElementCount();

        default public MutableComponent getLabel(int index) {
            return Component.literal((String)Integer.toString(index));
        }
    }
}

