/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.datagen;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.season.Season;
import sereneseasons.block.SeasonSensorBlock;

public class SSBlockStateProvider
extends BlockStateProvider {
    public SSBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "sereneseasons", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerSeasonSensor();
    }

    public void registerSeasonSensor() {
        Map<Season, ModelFile> models = Arrays.stream(Season.values()).collect(Collectors.toMap(key -> key, this::seasonSensor));
        this.getVariantBuilder(SSBlocks.SEASON_SENSOR).forAllStates(state -> {
            Season season = Season.values()[(Integer)state.getValue((Property)SeasonSensorBlock.SEASON)];
            return ConfiguredModel.builder().modelFile((ModelFile)models.get((Object)season)).build();
        });
        this.simpleBlockItem(SSBlocks.SEASON_SENSOR, models.get((Object)Season.SPRING));
    }

    public BlockModelBuilder seasonSensor(Season season) {
        String name = "season_sensor_" + season.name().toLowerCase();
        ResourceLocation topTexture = ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)("block/" + name + "_top"));
        ResourceLocation sideTexture = ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)"block/season_sensor_side");
        return this.daylightDetector(name, topTexture, sideTexture);
    }

    public BlockModelBuilder daylightDetector(String name, ResourceLocation top, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/template_daylight_detector")).texture("top", top)).texture("side", side);
    }
}

