/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import journeymap.client.JourneymapClient;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.ChatLog;
import journeymap.client.task.multi.RenderSpec;
import journeymap.common.Journeymap;
import journeymap.common.network.model.ClientState;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.ServerOption;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;

public class InternalStateHandler {
    private boolean journeyMapServerConnection = false;
    private boolean moddedServerConnection = false;
    private boolean expandedRadarEnabled = false;
    private boolean teleportEnabled = false;
    private boolean serverAdmin = false;
    private boolean useServerFullscreenBiomes = false;
    private boolean allowDeathPoints = true;
    private boolean showInGameBeacons = true;
    private boolean waypointsAllowed = true;
    private boolean multiplayerOptionsAllowed = true;
    private boolean readOnlyServerAdmin = true;
    private int maxSurfaceRenderDistance = 0;
    private int maxCaveRenderDistance = 0;
    private boolean rightClickTeleport = true;
    private boolean playerRadarNamesEnabled = true;
    private int radarLateralDistance = 512;
    private int radarVerticalDistance = 320;
    private int maxAnimalsData = 128;
    private int maxAmbientCreaturesData = 128;
    private int maxMobsData = 128;
    private int maxPlayersData = 128;
    private int maxVillagersData = 128;

    public void setStates(ClientState state) {
        GlobalProperties prop = (GlobalProperties)new GlobalProperties().loadForClient(state.getPayload(), false);
        if (!prop.journeymapEnabled.get().booleanValue()) {
            JourneymapClient.getInstance().disable();
            Journeymap.getLogger().info("Journeymap is Disabled by the server.");
            ChatLog.announceI18N("jm.common.disabled_by_server", new Object[0]);
        } else if (!JourneymapClient.getInstance().isInitialized().booleanValue()) {
            Journeymap.getLogger().info("Journeymap is enabled by the server.");
            ChatLog.announceI18N("jm.common.enabled_by_server", new Object[0]);
            JourneymapClient.getInstance().enable();
        }
        this.setModdedServerConnection(state.hasServerMod());
        this.setJourneyMapServerConnection(state.hasServerMod());
        this.setTeleportEnabled(prop.teleportEnabled.get());
        this.setExpandedRadarEnabled(((ServerOption)((Object)prop.worldPlayerRadar.get())).enabled());
        this.setServerAdmin(state.isServerAdmin());
        this.setAllowDeathPoints(prop.allowDeathPoints.get());
        this.setShowInGameBeacons(prop.showInGameBeacons.get());
        this.setWaypointsAllowed(prop.allowWaypoints.get());
        this.setReadOnlyServerAdmin(prop.viewOnlyServerProperties.get());
        this.setSurfaceMaxRenderDistance(prop.surfaceRenderRange.get());
        this.setCaveMaxRenderDistance(prop.caveRenderRange.get());
        this.setMultiplayerOptionsAllowed(((ServerOption)((Object)prop.allowMultiplayerSettings.get())).enabled());
        this.setAllowRightClickTeleport(prop.allowRightClickTeleport.get());
        this.setRadarLateralDistance(prop.radarLateralDistance.get());
        this.setRadarVerticalDistance(prop.radarVerticalDistance.get());
        this.setMaxAnimalsData(prop.maxAnimalsData.get());
        this.setMaxAmbientCreaturesData(prop.maxAmbientCreaturesData.get());
        this.setMaxMobsData(prop.maxMobsData.get());
        this.setMaxPlayersData(prop.maxPlayersData.get());
        this.setMaxVillagersData(prop.maxVillagersData.get());
        this.setPlayerRadarNamesEnabled(prop.playerRadarNamesEnabled.get());
        FeatureManager.getInstance().updateDimensionFeatures(prop);
    }

    public void reset() {
        this.journeyMapServerConnection = false;
        this.moddedServerConnection = false;
        this.expandedRadarEnabled = false;
        this.teleportEnabled = false;
        this.rightClickTeleport = true;
        this.serverAdmin = false;
        this.useServerFullscreenBiomes = false;
        this.allowDeathPoints = true;
        this.showInGameBeacons = true;
        this.waypointsAllowed = true;
        this.readOnlyServerAdmin = false;
        this.multiplayerOptionsAllowed = true;
        this.playerRadarNamesEnabled = true;
        this.maxCaveRenderDistance = 0;
        this.maxSurfaceRenderDistance = 0;
        this.radarLateralDistance = 512;
        this.radarVerticalDistance = 320;
        this.maxAnimalsData = 128;
        this.maxAmbientCreaturesData = 128;
        this.maxMobsData = 128;
        this.maxPlayersData = 128;
        this.maxVillagersData = 128;
        FeatureManager.getInstance().reset();
    }

    public boolean isAllowDeathPoints() {
        return this.allowDeathPoints;
    }

    private void setAllowDeathPoints(boolean allowDeathPoints) {
        WaypointGroupImpl deathGroup;
        this.allowDeathPoints = allowDeathPoints;
        if (!allowDeathPoints && (deathGroup = WaypointGroupStore.getInstance().get(WaypointGroupStore.DEATH.getGuid())) != null && !deathGroup.getWaypointIds().isEmpty()) {
            Journeymap.getLogger().debug("Death Points disabled by the server, deleting existing.");
            WaypointStore.getInstance().remove(deathGroup);
        }
    }

    public boolean isModdedServerConnection() {
        return this.moddedServerConnection;
    }

    private void setModdedServerConnection(boolean moddedServerConnection) {
        this.moddedServerConnection = moddedServerConnection;
    }

    public boolean isJourneyMapServerConnection() {
        return this.journeyMapServerConnection;
    }

    public void setJourneyMapServerConnection(boolean journeyMapServerConnection) {
        Journeymap.getLogger().debug("Connection initiated with Journeymap Server: {}", (Object)journeyMapServerConnection);
        this.journeyMapServerConnection = journeyMapServerConnection;
    }

    public boolean isExpandedRadarEnabled() {
        return this.expandedRadarEnabled;
    }

    private void setExpandedRadarEnabled(boolean expandedRadarEnabled) {
        if (Minecraft.getInstance().hasSingleplayerServer() && Minecraft.getInstance().getCurrentServer() != null && Minecraft.getInstance().getCurrentServer().isLan()) {
            this.expandedRadarEnabled = false;
            return;
        }
        Journeymap.getLogger().debug("Expanded Radar Enabled: {}", (Object)expandedRadarEnabled);
        this.expandedRadarEnabled = expandedRadarEnabled;
    }

    public boolean isTeleportEnabled() {
        return this.teleportEnabled;
    }

    private void setTeleportEnabled(boolean teleportEnabled) {
        Journeymap.getLogger().debug("Teleport Enabled: {}", (Object)teleportEnabled);
        this.teleportEnabled = teleportEnabled;
    }

    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    public boolean canServerAdmin() {
        return this.serverAdmin || Minecraft.getInstance().hasSingleplayerServer();
    }

    private void setServerAdmin(boolean serverAdmin) {
        Journeymap.getLogger().debug("Server Admin Enabled: {}", (Object)serverAdmin);
        this.serverAdmin = serverAdmin;
    }

    public boolean useServerFullscreenBiomes() {
        return this.useServerFullscreenBiomes;
    }

    private void setUseServerFullscreenBiomes(boolean useServerFullscreenBiomes) {
        Journeymap.getLogger().debug("Server fullscreen biomes: {}", (Object)useServerFullscreenBiomes);
        this.useServerFullscreenBiomes = useServerFullscreenBiomes;
    }

    public boolean canShowInGameBeacons() {
        return this.showInGameBeacons;
    }

    private void setShowInGameBeacons(boolean showInGameBeacons) {
        Journeymap.getLogger().debug("Server set show in-game beacons: {}", (Object)showInGameBeacons);
        this.showInGameBeacons = showInGameBeacons;
    }

    public boolean isWaypointsAllowed() {
        return this.waypointsAllowed;
    }

    private void setWaypointsAllowed(boolean waypointsAllowed) {
        Journeymap.getLogger().debug("Server set waypoints allowed: {}", (Object)waypointsAllowed);
        this.waypointsAllowed = waypointsAllowed;
    }

    public boolean isReadOnlyServerAdmin() {
        return this.readOnlyServerAdmin;
    }

    private void setReadOnlyServerAdmin(boolean readOnlyServerAdmin) {
        Journeymap.getLogger().debug("Server set Server Admin read only mode: {}", (Object)readOnlyServerAdmin);
        this.readOnlyServerAdmin = readOnlyServerAdmin;
    }

    public int getMaxSurfaceRenderDistance() {
        return this.maxSurfaceRenderDistance;
    }

    private void setSurfaceMaxRenderDistance(int maxSurfaceRenderDistance) {
        Journeymap.getLogger().debug("Server set maxSurfaceRenderDistance to: {}", (Object)maxSurfaceRenderDistance);
        this.maxSurfaceRenderDistance = maxSurfaceRenderDistance;
        RenderSpec.resetRenderSpecs();
    }

    public int getMaxCaveRenderDistance() {
        return this.maxCaveRenderDistance;
    }

    private void setCaveMaxRenderDistance(int maxCaveRenderDistance) {
        Journeymap.getLogger().debug("Server setmaxCaveRenderDistance to: {}", (Object)maxCaveRenderDistance);
        this.maxCaveRenderDistance = maxCaveRenderDistance;
        RenderSpec.resetRenderSpecs();
    }

    public boolean isMultiplayerOptionsAllowed() {
        return this.multiplayerOptionsAllowed;
    }

    private void setMultiplayerOptionsAllowed(boolean multiplayerOptionsAllowed) {
        Journeymap.getLogger().debug("Server set allow mutliplayer options: {}", (Object)multiplayerOptionsAllowed);
        this.multiplayerOptionsAllowed = multiplayerOptionsAllowed;
    }

    private void setAllowRightClickTeleport(boolean rightClickTeleport) {
        Journeymap.getLogger().debug("Server set allow rightClickTeleport options: {}", (Object)rightClickTeleport);
        this.rightClickTeleport = rightClickTeleport;
    }

    public boolean isAllowRightClickTeleport() {
        return this.rightClickTeleport;
    }

    public int getRadarLateralDistance() {
        return this.radarLateralDistance;
    }

    private void setRadarLateralDistance(int radarLateralDistance) {
        Journeymap.getLogger().debug("Server set allow radarLateralDistance options: {}", (Object)radarLateralDistance);
        this.radarLateralDistance = radarLateralDistance;
    }

    public int getRadarVerticalDistance() {
        return this.radarVerticalDistance;
    }

    private void setRadarVerticalDistance(int radarVerticalDistance) {
        Journeymap.getLogger().debug("Server set allow radarVerticalDistance options: {}", (Object)radarVerticalDistance);
        this.radarVerticalDistance = radarVerticalDistance;
    }

    public int getMaxAnimalsData() {
        return this.maxAnimalsData;
    }

    private void setMaxAnimalsData(int maxAnimalsData) {
        Journeymap.getLogger().debug("Server set allow maxAnimalsData options: {}", (Object)maxAnimalsData);
        this.maxAnimalsData = maxAnimalsData;
    }

    public int getMaxAmbientCreaturesData() {
        return this.maxAmbientCreaturesData;
    }

    private void setMaxAmbientCreaturesData(int maxAmbientCreaturesData) {
        Journeymap.getLogger().debug("Server set allow maxAmbientCreaturesData options: {}", (Object)maxAmbientCreaturesData);
        this.maxAmbientCreaturesData = maxAmbientCreaturesData;
    }

    public int getMaxMobsData() {
        return this.maxMobsData;
    }

    private void setMaxMobsData(int maxMobsData) {
        Journeymap.getLogger().debug("Server set allow maxMobsData options: {}", (Object)maxMobsData);
        this.maxMobsData = maxMobsData;
    }

    public int getMaxPlayersData() {
        return this.maxPlayersData;
    }

    private void setMaxPlayersData(int maxPlayersData) {
        Journeymap.getLogger().debug("Server set allow maxPlayersData options: {}", (Object)maxPlayersData);
        this.maxPlayersData = maxPlayersData;
    }

    public int getMaxVillagersData() {
        return this.maxVillagersData;
    }

    private void setMaxVillagersData(int maxVillagersData) {
        Journeymap.getLogger().debug("Server set allow maxVillagersData options: {}", (Object)maxVillagersData);
        this.maxVillagersData = maxVillagersData;
    }

    public boolean isPlayerRadarNamesEnabled() {
        return this.playerRadarNamesEnabled;
    }

    private void setPlayerRadarNamesEnabled(boolean playerRadarNamesEnabled) {
        Journeymap.getLogger().debug("Server set allow playerRadarNamesEnabled options: {}", (Object)playerRadarNamesEnabled);
        this.playerRadarNamesEnabled = playerRadarNamesEnabled;
    }
}

