/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.mojang.blaze3d.platform.NativeImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeRenderer
extends SurfaceRenderer
implements IChunkRenderer {
    protected StatTimer renderTopoTimer = StatTimer.get("BiomeRenderer.renderSurface");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(ComparableNativeImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.biome, null, chunkMd.getDimension()));
            boolean bl = this.renderSurface(chunkImage, regionData, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Chunk Error", t);
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean renderSurface(NativeImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            CompoundTag chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    CompoundTag blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                    BlockMD topBlockMd = null;
                    int y = Math.max(0, this.getBlockHeight(chunkMd, x, null, z, null, null));
                    topBlockMd = chunkMd.getBlockMD(x, y, z);
                    if (topBlockMd == null) {
                        this.paintBadBlock(chunkImage, x, y, z);
                        continue;
                    }
                    chunkOk = this.paintBiome(chunkImage, regionData, blockNbt, chunkMd, topBlockMd, x, y, z) || chunkOk;
                }
            }
            regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(org.apache.logging.log4j.Level.WARN, "Error in renderSurface: " + LogFormatter.toString(t));
        }
        return chunkOk;
    }

    private boolean paintBiome(NativeImage chunkImage, RegionData regionData, CompoundTag blockNbt, ChunkMD chunkMd, BlockMD topBlockMd, int x, int y, int z) {
        if (!chunkMd.hasChunk()) {
            return false;
        }
        BlockPos blockPos = chunkMd.getBlockPos(x, y, z);
        Holder<Biome> biome = chunkMd.getBiomeHolder(blockPos);
        if (biome == null) {
            return false;
        }
        BiomeMD biomeMD = BiomeMD.get((ResourceKey<Biome>)((ResourceKey)biome.unwrapKey().get()));
        try {
            boolean isWater = topBlockMd.isWater() || topBlockMd.isIce();
            boolean isFoliage = topBlockMd.isFoliage();
            int color = topBlockMd.isLava() ? topBlockMd.getTextureColor() : (isWater ? biomeMD.getWaterColor() : (isFoliage ? biomeMD.getFoliageColor() : (chunkMd.getDimension().equals((Object)Level.NETHER) ? biomeMD.getFogColor() : biomeMD.getGrassColor(chunkMd.getCoord().x, chunkMd.getCoord().z))));
            int blockColor = this.paintBlock(chunkImage, x, z, color);
            regionData.setBlockColor(blockNbt, blockColor, MapType.Name.biome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

