/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import journeymap.client.event.NeoForgeEventHandlerManager;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.ui.minimap.Effect;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class NeoForgeHudOverlayEvents
implements NeoForgeEventHandlerManager.EventHandler {
    private boolean shouldPop = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void preOverlayLow(RenderGuiLayerEvent.Pre event) {
        this.shouldPop = VanillaGuiLayers.EFFECTS.equals((Object)event.getName()) ? HudOverlayHandler.getInstance().preOverlay(event.getGuiGraphics()) : false;
        if (VanillaGuiLayers.DEBUG_OVERLAY.equals((Object)event.getName()) && Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen()) {
            HudOverlayHandler.getInstance().onRenderOverlay(event.getGuiGraphics());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void postGuiOverlay(RenderGuiEvent.Post event) {
        if (Effect.getInstance().canPotionShift()) {
            this.shouldPop = false;
        }
        if (!Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen()) {
            HudOverlayHandler.getInstance().onRenderOverlay(event.getGuiGraphics());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void postOverlayLayer(RenderGuiLayerEvent.Post event) {
        if (VanillaGuiLayers.EFFECTS.equals((Object)event.getName()) && this.shouldPop && Effect.getInstance().canPotionShift()) {
            HudOverlayHandler.getInstance().postOverlay(event.getGuiGraphics());
            this.shouldPop = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayDebug(CustomizeGuiOverlayEvent.DebugText event) {
        HudOverlayHandler.getInstance().onRenderOverlayDebug(event.getLeft());
    }
}

