/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.data.DataCache;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteItem;
import journeymap.client.ui.colorpalette.ColorPaletteScrollList;
import journeymap.client.ui.colorpalette.DomainDropDownButton;
import journeymap.client.ui.colorpalette.ModeDropDownButton;
import journeymap.client.ui.colorpalette.PaletteDropDownButton;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SortButton;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ColorPaletteScreen
extends JmUI {
    private final Component labelClose = Component.translatable((String)"jm.common.close");
    private final Component labelManagePalettes = Component.translatable((String)"jm.colorpalette.manage_palettes");
    private final Component labelModsAndPlayers = Component.translatable((String)"jm.colorpalette.mobs_and_players");
    private final Component labelRetrievingColors = Component.translatable((String)"jm.colorpalette.retrieving_colors");
    private static ColorPaletteItem.Sort currentSort;
    private static String searchString;
    LinearLayout firstHeaderLayout;
    LinearLayout secondHeaderLayout;
    protected ColorPaletteScrollList itemScrollPane;
    protected int rowHeight = 36;
    private SortButton buttonSortName;
    private SortButton buttonSortId;
    private ModeDropDownButton buttonMode;
    private PaletteDropDownButton buttonPalettes;
    private DomainDropDownButton buttonDomains;
    private SearchTextBox searchText;
    private ArrayList<? extends ColorPaletteItem> items = new ArrayList();
    private final ArrayList<ColorPaletteItem.Block> blockItems = new ArrayList();
    private final ArrayList<ColorPaletteItem.Biome> biomeItems = new ArrayList();
    private boolean remapNeeded = false;
    int firstHeaderHeight = 20;
    int secondHeaderHeight = 15;
    private Status status = Status.Uninitialized;
    private Iterator<BlockState> blockStatesToInitialize;
    private Iterator<Holder.Reference<Biome>> biomesToInitialize;
    private StringWidget initializingColorCountString;
    private int initializingColorCount = 0;

    public ColorPaletteScreen(Screen returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_colors_title"), true, returnDisplay);
    }

    @Override
    public void init() {
        super.init();
        if (this.status != Status.Initialized) {
            LinearLayout content = LinearLayout.horizontal();
            this.contentLayout.addChild((LayoutElement)content);
            content.addChild((LayoutElement)new StringWidget(this.labelRetrievingColors, this.font));
            content.addChild((LayoutElement)SpacerElement.width((int)6));
            this.initializingColorCountString = (StringWidget)content.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)"0"), this.font));
            this.initializingColorCountString.setWidth(this.font.width("0000000"));
            this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.refreshAndClose()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
            this.repositionElements();
            return;
        }
        LinearLayout content = LinearLayout.vertical();
        this.contentLayout.addChild((LayoutElement)content);
        this.firstHeaderLayout = LinearLayout.horizontal();
        this.firstHeaderLayout.spacing(2);
        content.addChild((LayoutElement)this.firstHeaderLayout, LayoutSettings::alignHorizontallyCenter);
        this.firstHeaderLayout.addChild((LayoutElement)SpacerElement.height((int)this.firstHeaderHeight));
        this.buttonMode = (ModeDropDownButton)this.firstHeaderLayout.addChild((LayoutElement)new ModeDropDownButton(b -> this.updateItems()), LayoutSettings::alignVerticallyMiddle);
        this.buttonMode.setDefaultStyle(false);
        this.buttonMode.setDrawBackground(false);
        this.buttonMode.setHeight(15);
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBlockStateColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBlockStateColors();
        this.buttonPalettes = (PaletteDropDownButton)this.firstHeaderLayout.addChild((LayoutElement)new PaletteDropDownButton(hasGlobal, hasWorld, b -> this.updateItems()), LayoutSettings::alignVerticallyMiddle);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.buttonPalettes.setDefaultStyle(false);
        this.buttonPalettes.setDrawBackground(false);
        this.buttonPalettes.setHeight(15);
        if (ColorManager.INSTANCE.getDefaultPalette().hasModdedBlockOrBiome()) {
            this.buttonDomains = (DomainDropDownButton)this.firstHeaderLayout.addChild((LayoutElement)new DomainDropDownButton(ColorManager.INSTANCE.getDefaultPalette(), b -> this.updateItems()), LayoutSettings::alignVerticallyMiddle);
            this.buttonDomains.setDefaultStyle(false);
            this.buttonDomains.setDrawBackground(false);
            this.buttonDomains.setHeight(15);
        }
        this.secondHeaderLayout = LinearLayout.horizontal();
        this.secondHeaderLayout.spacing(2);
        content.addChild((LayoutElement)this.secondHeaderLayout, LayoutSettings::alignHorizontallyCenter);
        this.secondHeaderLayout.addChild((LayoutElement)SpacerElement.height((int)this.secondHeaderHeight));
        this.buttonSortName = (SortButton)this.secondHeaderLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.colorpalette.name"), "name", false, this::sortButtonPressed), LayoutSettings::alignVerticallyMiddle);
        this.buttonSortId = (SortButton)this.secondHeaderLayout.addChild((LayoutElement)new SortButton(Constants.getString("jm.colorpalette.id"), "id", false, this::sortButtonPressed), LayoutSettings::alignVerticallyMiddle);
        this.searchText = (SearchTextBox)this.secondHeaderLayout.addChild((LayoutElement)new SearchTextBox(searchString, this.font, 70, 14), LayoutSettings::alignVerticallyMiddle);
        this.searchText.setBordered(false);
        this.searchText.setFillColor(0, 0.4f);
        this.searchText.setResponder(t -> this.updateItems());
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelModsAndPlayers, b -> UIManager.INSTANCE.openMobsAndPlayersColorEditor(this)).width(this.font.width((FormattedText)this.labelModsAndPlayers) + 10).build());
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelManagePalettes, b -> UIManager.INSTANCE.openColorPaletteManager(this)).width(this.font.width((FormattedText)this.labelManagePalettes) + 10).build());
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.refreshAndClose()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane = (ColorPaletteScrollList)content.addChild(new ColorPaletteScrollList(this.minecraft, 0, 36 + this.firstHeaderHeight + this.secondHeaderHeight, this.width, this.height - 36 - 30 - this.firstHeaderHeight - this.secondHeaderHeight, this.rowHeight));
        SortButton sortButton = this.getInitialSort();
        currentSort = this.getSortFromButton(sortButton);
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        if (this.status == Status.Initialized) {
            this.updateItems();
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.itemScrollPane.updateSize(this.width, this.height - 36 - 30 - this.firstHeaderHeight - this.secondHeaderHeight, 0, 36 + this.firstHeaderHeight + this.secondHeaderHeight);
            this.itemScrollPane.setListWidth(this.panelWidth());
            this.itemScrollPane.setScrollAmount(this.itemScrollPane.getScrollAmount());
        }
        super.repositionElements();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        ClientLevel level;
        if (this.status == Status.Uninitialized && (level = this.minecraft.level) != null) {
            this.blockStatesToInitialize = Block.BLOCK_STATE_REGISTRY.iterator();
            this.biomesToInitialize = level.registryAccess().registryOrThrow(Registries.BIOME).holders().iterator();
            this.status = Status.Initializing;
        }
        if (this.status == Status.Initializing) {
            long start = System.currentTimeMillis();
            boolean finished = false;
            while (!finished && System.currentTimeMillis() - start < 30L) {
                if (this.blockStatesToInitialize.hasNext()) {
                    BlockMD.get(this.blockStatesToInitialize.next());
                    ++this.initializingColorCount;
                }
                if (this.biomesToInitialize.hasNext()) {
                    BiomeMD.get((ResourceKey<Biome>)this.biomesToInitialize.next().key());
                    ++this.initializingColorCount;
                }
                String count = Integer.toString(this.initializingColorCount);
                this.initializingColorCountString.setMessage((Component)Component.literal((String)count));
                if (this.blockStatesToInitialize.hasNext() || this.biomesToInitialize.hasNext()) continue;
                finished = true;
                this.status = Status.Initialized;
                super.rebuildWidgets();
            }
        }
        if (this.status == Status.Initialized) {
            this.buttonSortName.setEnabled(!this.items.isEmpty());
            this.buttonSortId.setEnabled(!this.items.isEmpty());
        }
        super.render(graphics, x, y, partialTicks);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.outline(graphics, 0, 36, this.width - 1, this.height - 66);
        DrawUtil.drawRectangle(graphics, 0.0, 36 + this.firstHeaderHeight, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 36 + this.firstHeaderHeight + this.secondHeaderHeight, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.searchText != null && this.searchText.isMouseOver(mouseX, mouseY)) {
            this.searchText.mouseClicked(mouseX, mouseY, mouseButton);
            super.setFocused((GuiEventListener)this.searchText);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchText != null && this.searchText.isHoveredOrFocused()) {
            return this.searchText.charTyped(typedChar, keyCode);
        }
        return super.charTyped(typedChar, keyCode);
    }

    public void changeFocus(ComponentPath path) {
        super.changeFocus(path);
    }

    public void copyBlock(String blockId, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyBlockFromPalette(globalPalette, blockId);
        } else {
            globalPalette.copyBlockFromPalette(worldPalette, blockId);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.getSelected();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.id, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void copyBiome(String biomeId, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyBiomeFromPalette(globalPalette, biomeId);
        } else {
            globalPalette.copyBiomeFromPalette(worldPalette, biomeId);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.getSelected();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.id, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void removeBlockFromPalette(String blockId, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.removeBlock(blockId);
        this.updateItems();
        this.selectItem(blockId, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void removeBiomeFromPalette(String biomeId, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.removeBiome(biomeId);
        this.updateItems();
        this.selectItem(biomeId, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void setRemapNeeded() {
        this.remapNeeded = true;
    }

    protected void selectItem(String id, ColorPalette palette) {
        if (this.items.isEmpty()) {
            return;
        }
        int index = IntStream.range(0, this.items.size()).filter(i -> id.equals(this.items.get((int)i).id) && palette == this.items.get((int)i).palette).findFirst().orElse(0);
        ColorPaletteItem toSelect = (ColorPaletteItem)this.itemScrollPane.getSlot(index);
        this.itemScrollPane.setFocused((GuiEventListener)toSelect);
        toSelect.focusEditButton();
    }

    protected void updateItems() {
        if (this.searchText == null) {
            return;
        }
        if (this.buttonMode.getSelected().getId().equals("blocks")) {
            this.updateBlockItems();
            this.items = this.blockItems;
        } else {
            this.updateBiomeItems();
            this.items = this.biomeItems;
        }
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
        this.itemScrollPane.setScrollAmount(this.itemScrollPane.getScrollAmount());
    }

    protected void updateBlockItems() {
        ColorPaletteItem.Block item;
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBlockStateColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBlockStateColors();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.blockItems.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.getValue();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String blockId : defaultPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId)) continue;
                ColorPaletteItem.Block item2 = new ColorPaletteItem.Block(defaultPalette, blockId, false, this.getFontRenderer(), this);
                this.blockItems.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String blockId : globalPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId) || !defaultPalette.hasBlockId(blockId)) continue;
                item = new ColorPaletteItem.Block(globalPalette, blockId, all, this.getFontRenderer(), this);
                this.blockItems.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String blockId : worldPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockId) || !this.filterBlockSearch(searchString, blockId) || !defaultPalette.hasBlockId(blockId)) continue;
                item = new ColorPaletteItem.Block(worldPalette, blockId, all, this.getFontRenderer(), this);
                this.blockItems.add(item);
            }
        }
    }

    protected void updateBiomeItems() {
        ColorPaletteItem.Biome item;
        boolean hasGlobal = ColorManager.INSTANCE.getGlobalPalette().hasBiomeColors();
        boolean hasWorld = ColorManager.INSTANCE.getWorldPalette().hasBiomeColors();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.biomeItems.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.getValue();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String biomeId : defaultPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId)) continue;
                ColorPaletteItem.Biome item2 = new ColorPaletteItem.Biome(defaultPalette, biomeId, false, this.getFontRenderer(), this);
                this.biomeItems.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String biomeId : globalPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId) || !defaultPalette.hasBiomeId(biomeId)) continue;
                item = new ColorPaletteItem.Biome(globalPalette, biomeId, all, this.getFontRenderer(), this);
                this.biomeItems.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String biomeId : worldPalette.getAllBiomes()) {
                if (!this.filterDomain(domain, biomeId) || !this.filterBiomeSearch(searchString, biomeId) || !defaultPalette.hasBiomeId(biomeId)) continue;
                item = new ColorPaletteItem.Biome(worldPalette, biomeId, all, this.getFontRenderer(), this);
                this.biomeItems.add(item);
            }
        }
    }

    private int panelWidth() {
        return Math.min(this.width, 480);
    }

    private boolean filterDomain(String domain, String id) {
        return domain == null || domain.isEmpty() || ResourceLocation.parse((String)id).getNamespace().equals(domain);
    }

    private boolean filterBlockSearch(String search, String blockId) {
        String blockName = BlockMD.getBlockName((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockId))).toLowerCase(Locale.ROOT);
        return this.filterSearch(search, blockId, blockName);
    }

    private boolean filterBiomeSearch(String search, String biomeId) {
        String biomeName = BiomeHelper.getTranslatedBiomeName(ResourceLocation.parse((String)biomeId)).toLowerCase(Locale.ROOT);
        return this.filterSearch(search, biomeId, biomeName);
    }

    private boolean filterSearch(String search, String id, String name) {
        if (search == null || search.isEmpty()) {
            return true;
        }
        search = search.toLowerCase(Locale.ROOT);
        return id.toLowerCase(Locale.ROOT).contains(search) || name.contains(search);
    }

    private void sortButtonPressed(net.minecraft.client.gui.components.Button button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        currentSort = this.getSortFromButton(sortButton);
        this.updateSortProperty(sortButton);
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
    }

    private ColorPaletteItem.Sort getSortFromButton(SortButton sortButton) {
        if (sortButton.getKey().equals("name")) {
            return new ColorPaletteItem.NameComparator(sortButton.getToggled());
        }
        return new ColorPaletteItem.IdComparator(sortButton.getToggled());
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.remapNeeded) {
            DataCache.INSTANCE.resetBlockMetadata();
            DataCache.INSTANCE.resetBiomeMetadata();
            ColorManager.INSTANCE.savePalettes();
            MapPlayerTask.forceNearbyRemap();
        }
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    private SortButton getInitialSort() {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        boolean descending = prop.sortDescending.get();
        SortButton button = switch ((ColorPaletteItem.SortType)((Object)prop.initialSortOrder.get())) {
            default -> throw new MatchException(null, null);
            case ColorPaletteItem.SortType.Id -> this.buttonSortId;
            case ColorPaletteItem.SortType.Name -> this.buttonSortName;
        };
        button.setToggled(descending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Name);
        } else {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Id);
        }
        prop.sortDescending.set(sortButton.getToggled());
        prop.save();
    }

    static {
        searchString = "";
    }

    private static enum Status {
        Uninitialized,
        Initializing,
        Initialized;

    }
}

