/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.waypoint.ClientWaypointDAO;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.LegacyWaypointFileMigrator;
import journeymap.common.Journeymap;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;

public class WaypointHandler {
    private static WaypointHandler instance;
    private WaypointDAO dao;

    public static WaypointHandler getInstance() {
        if (instance == null) {
            instance = new WaypointHandler();
        }
        return instance;
    }

    public WaypointDAO getDao() {
        if (this.dao == null) {
            this.dao = JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() ? new ClientWaypointDAO() : new ClientWaypointDAO();
        }
        return this.dao;
    }

    public void reset() {
        this.dao = null;
        Journeymap.getLogger().info("Resetting Waypoints and Groups.");
        WaypointStore.getInstance().reset();
        WaypointGroupStore.getInstance().reset();
        List<ClientWaypointImpl> migratedWaypoints = LegacyWaypointFileMigrator.loadWaypoints(FileHandler.getWaypointDir());
        if (!migratedWaypoints.isEmpty()) {
            migratedWaypoints.forEach(wp -> WaypointStore.getInstance().save((ClientWaypointImpl)wp, false));
        }
    }
}

