/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.mojang.authlib.GameProfile;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = Services.COMMON_SERVICE.getServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayer) {
            creative = ((ServerPlayer)entity).getAbilities().instabuild;
            cheatMode = mcServer.getPlayerList().isOp(new GameProfile(entity.getUUID(), entity.getName().getString()));
            if (mcServer == null) {
                entity.sendSystemMessage((Component)Constants.getStringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || Services.COMMON_SERVICE.isOp((Player)((ServerPlayer)entity))) {
                if (!entity.isAlive()) {
                    entity.sendSystemMessage((Component)Constants.getStringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                ServerLevel destinationWorld = mcServer.getLevel(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (ServerLevel world : mcServer.getAllLevels()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((Level)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((ResourceKey<Level>)world.dimension()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    entity.sendSystemMessage((Component)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            entity.sendSystemMessage((Component)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(ServerLevel destinationWorld, Entity player, Location location) {
        boolean changedWorld;
        ServerLevel startWorld = (ServerLevel)player.getCommandSenderWorld();
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof ServerPlayer) {
            boolean crossDimTpAllow;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean bl2 = crossDimTpAllow = PropertiesManager.getInstance().getGlobalProperties().crossDimTeleport.get() != false || Services.COMMON_SERVICE.isOp((Player)((ServerPlayer)player));
            if (changedWorld) {
                if (crossDimTpAllow) {
                    serverPlayer.teleportTo(destinationWorld, location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5, player.getYRot(), player.getXRot());
                } else {
                    serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Server disabled cross dimension teleport."));
                }
            } else {
                serverPlayer.teleportTo(serverPlayer.serverLevel(), location.getX(), location.getY(), location.getZ(), player.getYRot(), player.getXRot());
            }
            if (!CommonConstants.debugOverride((Entity)serverPlayer)) {
                Journeymap.getLogger().info("{} teleported to {} {} {} {}", (Object)serverPlayer.getName().getString(), (Object)location.getX(), (Object)location.getY(), (Object)location.getZ(), (Object)location.getDim());
            }
        }
        return false;
    }
}

