/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework.handler;

import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientSessionData;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.impl.framework.FrameworkModConfig;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class FrameworkClientHandler {
    public static void handleResponse(MessageFramework.Response message, Consumer<Component> disconnect) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof RequestScreen)) {
            return;
        }
        RequestScreen requestScreen = (RequestScreen)screen;
        LocalPlayer player = minecraft.player;
        if (!ConfigHelper.isOperator((Player)player) || !ClientSessionData.isDeveloper()) {
            requestScreen.handleResponse(null, (Component)Component.translatable((String)"configured.gui.no_permission"));
            return;
        }
        IModConfig pendingConfig = requestScreen.getActiveConfig();
        if (!(pendingConfig instanceof FrameworkModConfig)) {
            requestScreen.handleResponse(null, (Component)Component.translatable((String)"configured.gui.request.invalid_config"));
            return;
        }
        FrameworkModConfig frameworkConfig = (FrameworkModConfig)pendingConfig;
        if (!pendingConfig.getType().isServer() || pendingConfig.getType().isSync() || pendingConfig.getType() == ConfigType.DEDICATED_SERVER) {
            requestScreen.handleResponse(null, (Component)Component.translatable((String)"configured.gui.request.invalid_config_type"));
            return;
        }
        if (!frameworkConfig.loadDataFromResponse(message)) {
            requestScreen.handleResponse(null, (Component)Component.translatable((String)"configured.gui.request.process_error"));
            return;
        }
        requestScreen.handleResponse(frameworkConfig, null);
    }
}

