/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;

public final class GroupedItemsPickup
implements IPickup {
    private final List<ItemStack> stacks = Lists.newArrayList();
    private int count;

    public GroupedItemsPickup(ItemStack stack) {
        this.stacks.add(stack);
        this.count = stack.getCount();
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int interval = Math.max(200, 1000 - 50 * this.stacks.size());
        ItemStack stack = this.stacks.get((int)(time / (long)interval % (long)this.stacks.size()));
        graphics.renderFakeItem(stack, -8, -8);
    }

    @Override
    public boolean tryMerge(IPickup pickup) {
        if (!(pickup instanceof GroupedItemsPickup)) {
            return false;
        }
        GroupedItemsPickup other = (GroupedItemsPickup)pickup;
        this.stacks.addAll(other.stacks);
        this.count += other.count;
        return true;
    }

    @Override
    public MutableComponent getDisplayName() {
        return (this.count <= 1 ? Component.translatable((String)"pickup.loot_journal.grouped_items_single") : Component.translatable((String)"pickup.loot_journal.grouped_items_multiple", (Object[])new Object[]{this.count})).withColor(LootJournal.CONFIG.groupedItemsColor);
    }

    @Override
    public boolean shouldDisplayTotal() {
        return false;
    }

    @Override
    public int getTotal() {
        return 0;
    }
}

