/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public final class ItemPickup
implements IPickup {
    private final ItemStack stack;
    private int count;
    private int total;

    public ItemPickup(ItemStack stack) {
        this.stack = stack;
        this.count = stack.getCount();
        this.countTotal(this.count);
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        graphics.renderFakeItem(this.stack, -8, -8);
    }

    @Override
    public boolean tryMerge(IPickup pickup) {
        if (!(pickup instanceof ItemPickup)) {
            return false;
        }
        ItemPickup other = (ItemPickup)pickup;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack)) {
            return false;
        }
        this.count += other.count;
        this.countTotal(other.count);
        return true;
    }

    @Override
    public MutableComponent getDisplayName() {
        MutableComponent result = this.count <= 1 ? Component.translatable((String)"pickup.loot_journal.item_single", (Object[])new Object[]{this.stack.getHoverName().getString()}) : Component.translatable((String)"pickup.loot_journal.item_multiple", (Object[])new Object[]{this.stack.getHoverName().getString(), this.count});
        return LootJournal.CONFIG.useRarityColor ? result.withStyle(this.stack.getRarity().color()) : result.withColor(LootJournal.CONFIG.itemsColor);
    }

    @Override
    public boolean shouldDisplayTotal() {
        return LootJournal.CONFIG.displayTotal && this.total > 1;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    private void countTotal(int origin) {
        this.total = origin;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        for (ItemStack stack : player.getInventory().items) {
            this.total += this.countSameItems(stack);
        }
    }

    private int countSameItems(ItemStack stack) {
        AtomicInteger counter = new AtomicInteger(0);
        if (ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack)) {
            counter.addAndGet(stack.getCount());
        }
        ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).stream().forEach(inner -> counter.addAndGet(this.countSameItems((ItemStack)inner)));
        return counter.get();
    }
}

