/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpanishMossBottomBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<SpanishMossBottomBlock> CODEC = SpanishMossBottomBlock.simpleCodec(SpanishMossBottomBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SpanishMossBottomBlock(BlockBehaviour.Properties p_i241194_1_) {
        super(p_i241194_1_, Direction.DOWN, SHAPE, false, 0.01);
    }

    public MapCodec<SpanishMossBottomBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_230332_1_) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)p_230332_1_);
    }

    protected Block getBodyBlock() {
        return BOPBlocks.SPANISH_MOSS_PLANT;
    }

    protected boolean canGrowInto(BlockState p_230334_1_) {
        return NetherVines.isValidGrowthState((BlockState)p_230334_1_);
    }

    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.relative(this.growthDirection.getOpposite());
        BlockState blockstate = p_196260_2_.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || blockstate.is(BlockTags.LEAVES) || blockstate.is(BlockTags.LOGS);
    }
}

