/*
 * Decompiled with CFR 0.152.
 */
package com.logprot.players;

import com.logprot.Logprot;
import com.logprot.config.CommonConfiguration;
import com.logprot.event.PlayerEventHandler;
import com.logprot.players.PlayerData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;

public class PlayerManager {
    private static PlayerManager instance;
    private Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();

    private PlayerManager() {
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
            NeoForge.EVENT_BUS.register((Object)PlayerEventHandler.getInstance());
        }
        return instance;
    }

    public void onPlayerLogin(Player player) {
        if (this.playerDataMap.containsKey(player.getUUID())) {
            return;
        }
        this.playerDataMap.put(player.getUUID(), new PlayerData(player, player.blockPosition(), System.currentTimeMillis() + (long)(((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime / 20) * 1000L));
        if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Player:" + player.getDisplayName().getString() + " now has protection for " + ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime + " ticks");
        }
    }

    public void updatePlayers() {
        if (this.playerDataMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, PlayerData>> iterator = this.playerDataMap.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            if (!entry.getValue().player.isAlive()) {
                iterator.remove();
                break;
            }
            if (entry.getValue().invulTimePoint > currentTime) continue;
            if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
                Logprot.LOGGER.info("Player:" + entry.getValue().player.getName().getString() + " got their login protection removed due to timeout");
            }
            entry.getValue().player.hurtTime = 0;
            iterator.remove();
        }
    }

    public boolean isPlayerImmune(Player playerEntity, DamageSource source) {
        if (source == playerEntity.damageSources().fall() && ((CommonConfiguration)Logprot.config.getCommonConfig()).ignoreFallDamage) {
            return false;
        }
        this.updatePlayers();
        return this.playerDataMap.containsKey(playerEntity.getUUID());
    }

    public void onPlayerTeleport(ServerPlayer player) {
        this.playerDataMap.put(player.getUUID(), new PlayerData((Player)player, new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ()), ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime));
        if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Teleported player:" + player.getName().getString() + " now has login protection for " + ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime + " ticks");
        }
    }

    public void removeProtection(ServerPlayer player) {
        if (player != null && this.playerDataMap.containsKey(player.getUUID()) && this.playerDataMap.remove(player.getUUID()) != null && ((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Player:" + player.getName().getString() + " got their login protection removed due to activity");
        }
    }
}

