/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import java.nio.IntBuffer;
import java.util.function.IntConsumer;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.MixedDirectionData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.StaticSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TopoGraphSorting;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.minecraft.core.SectionPos;

public class StaticTopoData
extends MixedDirectionData {
    private Sorter sorterOnce;

    StaticTopoData(SectionPos sectionPos, int vertexCount, int quadCount) {
        super(sectionPos, vertexCount, quadCount);
    }

    @Override
    public SortType getSortType() {
        return SortType.STATIC_TOPO;
    }

    @Override
    public Sorter getSorter() {
        Sorter sorter = this.sorterOnce;
        if (sorter == null) {
            throw new IllegalStateException("Sorter already used!");
        }
        this.sorterOnce = null;
        return sorter;
    }

    public static StaticTopoData fromMesh(int vertexCount, TQuad[] quads, SectionPos sectionPos) {
        StaticSorter sorter = new StaticSorter(quads.length);
        QuadIndexConsumerIntoBuffer indexWriter = new QuadIndexConsumerIntoBuffer(sorter.getIntBuffer());
        if (!TopoGraphSorting.topoGraphSort(indexWriter, quads, null, null)) {
            sorter.getIndexBuffer().free();
            return null;
        }
        StaticTopoData staticTopoData = new StaticTopoData(sectionPos, vertexCount, quads.length);
        staticTopoData.sorterOnce = sorter;
        return staticTopoData;
    }

    private record QuadIndexConsumerIntoBuffer(IntBuffer buffer) implements IntConsumer
    {
        @Override
        public void accept(int value) {
            TranslucentData.writeQuadVertexIndexes(this.buffer, value);
        }
    }
}

