/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class EndIslandCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"end_island").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(context -> EndIslandCommand.executeReset((CommandSourceStack)context.getSource(), false))).then(Commands.argument((String)"forceNewPortalPos", (ArgumentType)BoolArgumentType.bool()).executes(context -> EndIslandCommand.executeReset((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"forceNewPortalPos"))))));
    }

    public static int executeReset(CommandSourceStack commandSource, boolean forcePortalPosReset) {
        ServerLevel serverLevel = commandSource.getServer().getLevel(Level.END);
        if (serverLevel == null) {
            commandSource.sendFailure((Component)Component.literal((String)"Could not find the End dimension."));
            return -1;
        }
        if (serverLevel.getDragonFight() == null) {
            commandSource.sendFailure((Component)Component.literal((String)"Could not find the dragon fight."));
            return -1;
        }
        IDragonFight dragonFight = (IDragonFight)serverLevel.getDragonFight();
        dragonFight.betterendisland$reset(forcePortalPosReset);
        commandSource.sendSuccess(() -> Component.literal((String)"Ender Dragon fight has been reset."), false);
        return 1;
    }
}

