/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.DragonRespawnStage;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndPodiumFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndSpawnPlatformFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterSpikeFeature;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMixin
implements IDragonFight {
    @Shadow
    @Final
    private ServerBossEvent dragonEvent;
    @Shadow
    private boolean dragonKilled;
    @Shadow
    private int ticksSinceLastPlayerScan;
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    private boolean needsStateScanning;
    @Shadow
    @Nullable
    private List<EndCrystal> respawnCrystals;
    @Shadow
    private int respawnTime;
    @Shadow
    @Nullable
    private BlockPos portalLocation;
    @Shadow
    @Nullable
    private UUID dragonUUID;
    @Shadow
    private int ticksSinceDragonSeen;
    @Shadow
    private int ticksSinceCrystalsScanned;
    @Shadow
    private boolean previouslyKilled;
    @Shadow
    private int crystalsAlive;
    @Shadow
    @Nullable
    private DragonRespawnAnimation respawnStage;
    @Shadow
    @Final
    private ObjectArrayList<Integer> gateways;
    @Unique
    private DragonRespawnStage betterendisland$dragonRespawnStage;
    @Unique
    private boolean betterendisland$firstExitPortalSpawn = true;
    @Unique
    private boolean betterendisland$hasDragonEverSpawned;
    @Unique
    private int betterendisland$numberTimesDragonKilled = 0;

    @Shadow
    public abstract void resetSpikeCrystals();

    @Shadow
    public abstract void tryRespawn();

    @Shadow
    protected abstract void updatePlayers();

    @Shadow
    protected abstract boolean isArenaLoaded();

    @Shadow
    protected abstract void findOrCreateDragon();

    @Shadow
    protected abstract void updateCrystalCount();

    @Shadow
    protected abstract EnderDragon createNewDragon();

    @Shadow
    @Nullable
    protected abstract BlockPattern.BlockPatternMatch findExitPortal();

    @Shadow
    protected abstract void respawnDragon(List<EndCrystal> var1);

    @Shadow
    protected abstract boolean hasActiveExitPortal();

    @Shadow
    protected abstract void spawnNewGateway();

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;JLnet/minecraft/world/level/dimension/end/EndDragonFight$Data;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    public void betterendisland_EndDragonFight(ServerLevel level, long seed, EndDragonFight.Data data, BlockPos origin, CallbackInfo ci) {
        if (data.isRespawning()) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
        }
        this.dragonEvent.setVisible(false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tickFight(CallbackInfo ci) {
        this.dragonEvent.setVisible(!this.dragonKilled && this.betterendisland$hasDragonEverSpawned);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addRegionTicket(TicketType.DRAGON, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean isArenaLoaded = this.isArenaLoaded();
            if (this.needsStateScanning && isArenaLoaded) {
                this.betterendisland$scanForInitialState();
                this.needsStateScanning = false;
            }
            if (this.betterendisland$dragonRespawnStage != null) {
                if (this.respawnCrystals == null && isArenaLoaded) {
                    this.betterendisland$dragonRespawnStage = null;
                    this.tryRespawn();
                }
                this.betterendisland$dragonRespawnStage.tick(this.level, (EndDragonFight)this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && isArenaLoaded && this.betterendisland$hasDragonEverSpawned) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && isArenaLoaded) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeRegionTicket(TicketType.DRAGON, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$reset(boolean forcePortalPosReset) {
        List dragons = this.level.getDragons();
        dragons.forEach(Entity::discard);
        this.dragonEvent.setProgress(0.0f);
        this.dragonEvent.setVisible(false);
        if (this.portalLocation == null || this.portalLocation.getY() < 5 || forcePortalPosReset) {
            BetterEndIslandCommon.LOGGER.info("Tried to reset, but need to find the portal first.");
            if (this.portalLocation == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently null.");
            } else if (this.portalLocation.getY() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently too low: {}", (Object)this.portalLocation.getY());
            } else {
                BetterEndIslandCommon.LOGGER.info("Forcing portal position reset...");
            }
            this.findExitPortal();
            if (this.portalLocation == null || this.portalLocation.getY() < 5 || forcePortalPosReset) {
                if (this.portalLocation == null) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still null. Placing manually...");
                } else if (this.portalLocation.getY() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still too low: {}. Placing manually...", (Object)this.portalLocation.getY());
                }
                this.portalLocation = new BlockPos(0, this.betterendisland$getSurfacePos(0, 0), 0);
                while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > this.level.getSeaLevel()) {
                    this.portalLocation = this.portalLocation.below();
                }
                if (this.portalLocation.getY() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal was still placed too low! Force placing at y=65...");
                    this.portalLocation = new BlockPos(this.portalLocation.getX(), 65, this.portalLocation.getZ());
                }
            }
        }
        BlockPos portalPos = this.portalLocation;
        this.dragonUUID = null;
        this.dragonKilled = false;
        this.previouslyKilled = false;
        this.betterendisland$firstExitPortalSpawn = false;
        this.betterendisland$hasDragonEverSpawned = false;
        this.betterendisland$numberTimesDragonKilled = 0;
        this.betterendisland$dragonRespawnStage = null;
        this.respawnStage = null;
        this.respawnTime = 0;
        this.needsStateScanning = true;
        this.ticksSinceLastPlayerScan = 0;
        this.ticksSinceDragonSeen = 0;
        this.crystalsAlive = 0;
        this.ticksSinceCrystalsScanned = 0;
        if (this.respawnCrystals != null) {
            this.respawnCrystals.forEach(Entity::discard);
        }
        this.respawnCrystals = null;
        List<EndCrystal> remainingSummoningCrystals = this.betterendisland$checkRespawnCrystals(portalPos.above(1));
        remainingSummoningCrystals.forEach(Entity::discard);
        remainingSummoningCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.below(2));
        remainingSummoningCrystals.forEach(Entity::discard);
        List allSpikes = SpikeFeature.getSpikesForLevel((WorldGenLevel)this.level);
        for (SpikeFeature.EndSpike spike2 : allSpikes) {
            for (EndCrystal crystal : this.level.getEntitiesOfClass(EndCrystal.class, spike2.getTopBoundingBox())) {
                crystal.discard();
            }
        }
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(true, false, false);
        BlockPos spawnPos = portalPos.below(5);
        endPodiumFeature.place((FeatureConfiguration)FeatureConfiguration.NONE, (WorldGenLevel)this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), spawnPos);
        this.betterendisland$clearVanillaPillars();
        allSpikes.forEach(spike -> {
            int resetRadius = 11;
            int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)new BlockPos(spike.getCenterX() - resetRadius, spike.getHeight() - verticalRadius, spike.getCenterZ() - resetRadius), (BlockPos)new BlockPos(spike.getCenterX() + resetRadius, spike.getHeight() + verticalRadius, spike.getCenterZ() + resetRadius))) {
                if (this.level.getBlockState(blockPos).is(Blocks.END_STONE)) continue;
                this.level.removeBlock(blockPos, false);
            }
            SpikeConfiguration spikeConfig = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), null);
            BetterSpikeFeature.placeSpike((ServerLevelAccessor)this.level, RandomSource.create(), spikeConfig, spike, true);
        });
        BlockPos platformPos = ServerLevel.END_SPAWN_POINT.below();
        if (BetterEndIslandCommon.CONFIG.useVanillaSpawnPlatform) {
            EndPlatformFeature.createEndPlatform((ServerLevelAccessor)this.level, (BlockPos)platformPos, (boolean)false);
        } else {
            BetterEndSpawnPlatformFeature.place((ServerLevelAccessor)this.level, platformPos, false);
        }
        for (int i = 0; i < 20; ++i) {
            int x = Mth.floor((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int z = Mth.floor((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            BlockPos gatePos = new BlockPos(x, 75, z);
            BlockPos.betweenClosed((BlockPos)gatePos.offset(-1, -4, -1), (BlockPos)gatePos.offset(1, 4, 1)).forEach(pos -> this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState()));
        }
        this.gateways.clear();
        this.gateways.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
        Util.shuffle(this.gateways, (RandomSource)RandomSource.create((long)this.level.getSeed()));
    }

    @Override
    public void betterendisland$clearVanillaPillars() {
        int obsidianRemoved = 0;
        RandomSource randomSource = RandomSource.create((long)this.level.getSeed());
        long seed = randomSource.nextLong() & 0xFFFFL;
        IntArrayList indexes = Util.toShuffledList((IntStream)IntStream.range(0, 10), (RandomSource)RandomSource.create((long)seed));
        for (int i = 0; i < 10; ++i) {
            int x = Mth.floor((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = Mth.floor((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = indexes.get(i);
            int radius = 2 + index / 3;
            int height = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            AABB topBoundingBox = new AABB((double)(x - radius), (double)DimensionType.MIN_Y, (double)(z - radius), (double)(x + radius), (double)DimensionType.MAX_Y, (double)(z + radius));
            this.level.getEntitiesOfClass(EndCrystal.class, topBoundingBox).forEach(Entity::discard);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(x - radius, this.level.getMinBuildHeight(), z - radius), (BlockPos)new BlockPos(x + radius, height + 20, z + radius))) {
                BlockState blockState;
                if (!(pos.distToLowCornerSqr((double)x, (double)pos.getY(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.level.getBlockState(pos)).is(Blocks.OBSIDIAN) && !blockState.is(Blocks.BEDROCK)) continue;
                this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (!blockState.is(Blocks.OBSIDIAN)) continue;
                ++obsidianRemoved;
            }
            if (obsidianRemoved > 10) {
                int offset = radius + 1;
                int topY = -1;
                int surfaceY = this.betterendisland$getSurfacePos(x - offset, z - offset);
                if (surfaceY > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x - offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z - offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                int bottomY = 255;
                surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z - offset);
                if (surfaceY < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z - offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if (topY != -1 && bottomY != 255) {
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(x - radius, bottomY, z - radius), (BlockPos)new BlockPos(x + radius, topY, z + radius))) {
                        BlockState blockState;
                        if (!(pos.distToLowCornerSqr((double)x, (double)pos.getY(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.level.getBlockState(pos)).is(Blocks.AIR) || pos.getY() > topY || pos.getY() < bottomY) continue;
                        this.level.setBlockAndUpdate(pos, Blocks.END_STONE.defaultBlockState());
                    }
                }
            }
            if (!isGuarded) continue;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int fenceX = -2; fenceX <= 2; ++fenceX) {
                for (int fenceZ = -2; fenceZ <= 2; ++fenceZ) {
                    for (int fenceY = 0; fenceY <= 3; ++fenceY) {
                        if (Mth.abs((int)fenceX) != 2 && Mth.abs((int)fenceZ) != 2 && fenceY != 3) continue;
                        mutable.set(x + fenceX, height + fenceY, z + fenceZ);
                        this.level.setBlockAndUpdate((BlockPos)mutable, Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
    }

    @Unique
    private int betterendisland$getLowestBlockPos(int x, int z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = this.level.getMinBuildHeight(); y < this.level.getMaxBuildHeight(); ++y) {
            mutable.set(x, y, z);
            if (!this.level.getBlockState((BlockPos)mutable).is(Blocks.END_STONE)) continue;
            return y;
        }
        return 255;
    }

    @Unique
    private int betterendisland$getSurfacePos(int x, int z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = this.level.getMaxBuildHeight(); y > this.level.getMinBuildHeight(); --y) {
            mutable.set(x, y, z);
            if (!this.level.getBlockState((BlockPos)mutable).is(Blocks.END_STONE)) continue;
            return y;
        }
        return -1;
    }

    @Unique
    private void betterendisland$scanForInitialState() {
        BetterEndIslandCommon.LOGGER.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.hasActiveExitPortal();
        if (hasActiveExitPortal) {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.betterendisland$spawnPortal(false, false);
            }
        }
        List dragons = this.level.getDragons();
        if (dragons.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EnderDragon dragon = (EnderDragon)dragons.get(0);
            this.dragonUUID = dragon.getUUID();
            BetterEndIslandCommon.LOGGER.info("Found that there's a dragon still alive ({})", (Object)dragon);
            this.dragonKilled = false;
            if (!hasActiveExitPortal) {
                BetterEndIslandCommon.LOGGER.info("But we didn't have a portal, so let's remove the dragon.");
                dragon.discard();
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    @Inject(method={"onCrystalDestroyed"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_onCrystalDestroyed(EndCrystal crystal, DamageSource damageSource, CallbackInfo ci) {
        if (this.betterendisland$dragonRespawnStage != null && this.respawnCrystals.contains(crystal)) {
            BetterEndIslandCommon.LOGGER.info("Aborting dragon respawn sequence");
            this.betterendisland$dragonRespawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
        } else {
            this.updateCrystalCount();
            Entity dragonEntity = this.level.getEntity(this.dragonUUID);
            if (dragonEntity instanceof EnderDragon) {
                ((EnderDragon)dragonEntity).onCrystalDestroyed(crystal, crystal.blockPosition(), damageSource);
            }
        }
        ci.cancel();
    }

    @Inject(method={"tryRespawn"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tryRespawn(CallbackInfo ci) {
        if (this.dragonKilled && this.betterendisland$dragonRespawnStage == null) {
            List<EndCrystal> allCrystals;
            BlockPos portalPos = this.portalLocation;
            if (portalPos == null) {
                BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch portalPatternMatch = this.findExitPortal();
                if (portalPatternMatch == null) {
                    BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                    this.betterendisland$spawnPortal(false, false);
                    this.betterendisland$spawnPortal(true, true);
                } else {
                    BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
                }
                portalPos = this.portalLocation;
            }
            if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.above(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.below(2))).size() != 4) {
                return;
            }
            BetterEndIslandCommon.LOGGER.info("Found all crystals, respawning dragon.");
            this.respawnDragon(allCrystals);
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void betterendisland$initialRespawn() {
        List<EndCrystal> allCrystals;
        BetterEndIslandCommon.LOGGER.info("Starting initial dragon fight!");
        BlockPos portalPos = this.portalLocation;
        if (portalPos == null) {
            BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
            BlockPattern.BlockPatternMatch portalPatternMatch = this.findExitPortal();
            if (portalPatternMatch == null) {
                BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                this.betterendisland$spawnPortal(false, false);
                this.betterendisland$spawnPortal(true, true);
            } else {
                BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
            }
            portalPos = this.portalLocation;
        }
        if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.above(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.below(2))).size() != 4) {
            BetterEndIslandCommon.LOGGER.info("Unable to find all 4 summoning crystals. This shouldn't happen!");
            return;
        }
        BetterEndIslandCommon.LOGGER.info("Found all crystals, starting initial dragon spawn.");
        this.respawnDragon(allCrystals);
    }

    @Unique
    private List<EndCrystal> betterendisland$checkRespawnCrystals(BlockPos centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            AABB crystalCheckbox = new AABB(centerPos.relative(direction, 7));
            List crystalsInDirection = this.level.getEntitiesOfClass(EndCrystal.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Unique
    private List<EndCrystal> betterendisland$checkVanillaRespawnCrystals(BlockPos centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            AABB crystalCheckbox = new AABB(centerPos.relative(direction, 2));
            List crystalsInDirection = this.level.getEntitiesOfClass(EndCrystal.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Inject(method={"respawnDragon"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterendisland_respawnDragon(List<EndCrystal> crystals, CallbackInfo ci) {
        if ((this.dragonKilled || !this.betterendisland$hasDragonEverSpawned) && this.betterendisland$dragonRespawnStage == null) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
            this.respawnTime = 0;
            this.respawnCrystals = crystals;
        }
        ci.cancel();
    }

    @Unique
    private void betterendisland$spawnPortal(boolean isActive, boolean isBottomOnly) {
        if (this.portalLocation == null || this.portalLocation.getY() < 5) {
            if (this.portalLocation == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is null. Placing manually...");
            } else {
                BetterEndIslandCommon.LOGGER.info("Portal location is too low: {}. Placing manually...", (Object)this.portalLocation.getY());
            }
            this.portalLocation = new BlockPos(0, this.betterendisland$getSurfacePos(0, 0), 0);
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > this.level.getSeaLevel()) {
                this.portalLocation = this.portalLocation.below();
            }
            if (this.portalLocation.getY() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal was placed too low! Force placing at y=65...");
                this.portalLocation = new BlockPos(this.portalLocation.getX(), 65, this.portalLocation.getZ());
            }
        }
        BetterEndIslandCommon.LOGGER.info("Set the exit portal location to: {}", (Object)this.portalLocation);
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(this.betterendisland$firstExitPortalSpawn, isBottomOnly, isActive);
        BlockPos spawnPos = this.portalLocation.below(5);
        endPodiumFeature.place((FeatureConfiguration)FeatureConfiguration.NONE, (WorldGenLevel)this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), spawnPos);
        this.betterendisland$firstExitPortalSpawn = false;
    }

    @Inject(method={"resetSpikeCrystals"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_resetSpikeCrystals(CallbackInfo ci) {
        for (SpikeFeature.EndSpike $$0 : SpikeFeature.getSpikesForLevel((WorldGenLevel)this.level)) {
            for (EndCrystal $$2 : this.level.getEntitiesOfClass(EndCrystal.class, $$0.getTopBoundingBox())) {
                $$2.setInvulnerable(false);
                $$2.setBeamTarget(null);
            }
        }
        if (this.respawnCrystals != null) {
            for (EndCrystal crystal : this.respawnCrystals) {
                crystal.setInvulnerable(false);
                crystal.setBeamTarget(null);
            }
        }
        ci.cancel();
    }

    @Inject(method={"setDragonKilled"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_setDragonKilled(EnderDragon dragon, CallbackInfo ci) {
        if (dragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.betterendisland$spawnPortal(true, true);
            this.level.explode(null, (double)this.portalLocation.getX(), (double)this.portalLocation.getY(), (double)this.portalLocation.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
            this.spawnNewGateway();
            if (!this.previouslyKilled || BetterEndIslandCommon.moreDragonEggs || BetterEndIslandCommon.CONFIG.resummonedDragonDropsEgg) {
                this.level.setBlockAndUpdate(this.portalLocation.above(), Blocks.DRAGON_EGG.defaultBlockState());
            }
            int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
            List spikes = SpikeFeature.getSpikesForLevel((WorldGenLevel)this.level);
            spikes.forEach(spike -> {
                int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
                this.level.setBlock(new BlockPos(spike.getCenterX(), crystalY - 1, spike.getCenterZ()), Blocks.OBSIDIAN.defaultBlockState(), 3);
            });
            this.previouslyKilled = true;
            this.dragonKilled = true;
            ++this.betterendisland$numberTimesDragonKilled;
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$setDragonRespawnStage(DragonRespawnStage stage) {
        if (this.betterendisland$dragonRespawnStage == null) {
            throw new IllegalStateException("Better Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (stage == DragonRespawnStage.END) {
            this.betterendisland$dragonRespawnStage = null;
            this.dragonKilled = false;
            EnderDragon newDragon = this.createNewDragon();
            if (this.previouslyKilled) {
                for (ServerPlayer serverPlayer : this.dragonEvent.getPlayers()) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)newDragon);
                }
            }
            this.betterendisland$spawnPortal(false, false);
            this.level.explode(null, (double)this.portalLocation.getX(), (double)(this.portalLocation.getY() + 20), (double)this.portalLocation.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
            this.level.players().forEach(player -> {
                this.level.sendParticles(player, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)this.portalLocation.getX(), (double)(this.portalLocation.getY() + 20), (double)this.portalLocation.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                if (player.distanceToSqr((double)this.portalLocation.getX(), (double)(this.portalLocation.getY() + 20), (double)this.portalLocation.getZ()) > 32.0) {
                    this.level.playSound(null, this.portalLocation.above(20), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 24.0f, 1.0f);
                }
            });
            if (this.betterendisland$hasDragonEverSpawned) {
                this.betterendisland$spawnPortal(false, true);
                this.level.explode(null, (double)this.portalLocation.getX(), (double)this.portalLocation.getY(), (double)this.portalLocation.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
            }
            int dragonKills = Mth.clamp((int)this.betterendisland$numberTimesDragonKilled, (int)0, (int)10);
            float cryingChance = Mth.lerp((float)((float)dragonKills / 10.0f), (float)0.0f, (float)0.5f);
            ArrayList existingGateways = new ArrayList(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            existingGateways.removeAll((Collection<?>)this.gateways);
            existingGateways.forEach(gateway -> {
                int x = Mth.floor((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                int z = Mth.floor((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                BlockPos gatewayPos = new BlockPos(x, 75, z);
                RandomSource gatewayRandom = RandomSource.create((long)Mth.getSeed((Vec3i)gatewayPos));
                BlockPos.betweenClosed((BlockPos)gatewayPos.offset(-1, -4, -1), (BlockPos)gatewayPos.offset(1, 4, 1)).forEach(pos -> {
                    if (this.level.getBlockState(pos).is(Blocks.OBSIDIAN) && gatewayRandom.nextFloat() < cryingChance) {
                        this.level.setBlockAndUpdate(pos, Blocks.CRYING_OBSIDIAN.defaultBlockState());
                    }
                });
            });
            BlockPos platformPos = ServerLevel.END_SPAWN_POINT;
            RandomSource platformRandom = RandomSource.create((long)Mth.getSeed((Vec3i)platformPos));
            BlockPos.betweenClosed((BlockPos)platformPos.offset(-3, -15, -3), (BlockPos)platformPos.offset(3, 4, 3)).forEach(pos -> {
                if (this.level.getBlockState(pos).is(Blocks.OBSIDIAN) && platformRandom.nextFloat() < cryingChance) {
                    this.level.setBlockAndUpdate(pos, Blocks.CRYING_OBSIDIAN.defaultBlockState());
                }
            });
            this.betterendisland$hasDragonEverSpawned = true;
        } else {
            this.betterendisland$dragonRespawnStage = stage;
        }
    }

    @Override
    public void betterendisland$tickBellSound() {
        if (!this.betterendisland$hasDragonEverSpawned || this.betterendisland$dragonRespawnStage != null) {
            int soundY;
            long gameTime = this.level.getGameTime();
            int n = soundY = this.portalLocation == null ? 80 : this.portalLocation.getY() + 15;
            if (gameTime % 100L == 0L) {
                this.level.playSound(null, new BlockPos(0, soundY, 0), SoundEvents.BELL_BLOCK, SoundSource.NEUTRAL, 24.0f, 0.5f);
                this.level.playSound(null, new BlockPos(0, soundY, 0), SoundEvents.BELL_RESONATE, SoundSource.NEUTRAL, 4.0f, 0.9f);
            }
            if (gameTime % 300L == 0L) {
                this.level.playSound(null, new BlockPos(0, 80, 0), SoundEvents.BELL_RESONATE, SoundSource.NEUTRAL, 24.0f, 0.8f);
            }
        }
    }

    @Override
    public DragonRespawnStage betterendisland$getDragonRespawnStage() {
        return this.betterendisland$dragonRespawnStage;
    }

    @Override
    public boolean betterendisland$firstExitPortalSpawn() {
        return this.betterendisland$firstExitPortalSpawn;
    }

    @Override
    public boolean betterendisland$hasDragonEverSpawned() {
        return this.betterendisland$hasDragonEverSpawned;
    }

    @Override
    public int betterendisland$numTimesDragonKilled() {
        return this.betterendisland$numberTimesDragonKilled;
    }

    @Override
    public void betterendisland$setFirstExitPortalSpawn(boolean bl) {
        this.betterendisland$firstExitPortalSpawn = bl;
    }

    @Override
    public void betterendisland$setHasDragonEverSpawned(boolean bl) {
        this.betterendisland$hasDragonEverSpawned = bl;
    }

    @Override
    public void betterendisland$setNumTimesDragonKilled(int i) {
        this.betterendisland$numberTimesDragonKilled = i;
    }
}

