/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterEndGatewayFeature {
    private static final List<StructureProcessor> PROCESSORS = List.of(new DragonEggProcessor());

    public static boolean place(FeaturePlaceContext<EndGatewayConfiguration> ctx) {
        ServerLevel serverLevel;
        BlockPos origin = ctx.origin();
        WorldGenLevel level = ctx.level();
        EndGatewayConfiguration config = (EndGatewayConfiguration)ctx.config();
        int numberTimesDragonKilled = 0;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getDragonFight() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.getDragonFight()).betterendisland$numTimesDragonKilled();
        }
        ResourceLocation template = ResourceLocation.fromNamespaceAndPath((String)"betterendisland", (String)"gateway");
        boolean placed = BetterEndGatewayFeature.placeTemplate((ServerLevelAccessor)level, ctx.random(), origin, template, numberTimesDragonKilled);
        BlockPos portalPos = new BlockPos((Vec3i)origin);
        level.setBlock(portalPos, Blocks.END_GATEWAY.defaultBlockState(), 3);
        config.getExit().ifPresent(exitPos -> {
            BlockEntity blockentity = level.getBlockEntity(portalPos);
            if (blockentity instanceof TheEndGatewayBlockEntity) {
                TheEndGatewayBlockEntity theendgatewayblockentity = (TheEndGatewayBlockEntity)blockentity;
                theendgatewayblockentity.setExitPosition(exitPos, config.isExitExact());
                blockentity.setChanged();
            }
        });
        return placed;
    }

    private static boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.getLevel().getStructureManager().get(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.offset(-template.getSize().getX() / 2, -template.getSize().getY() / 2, -template.getSize().getZ() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).addProcessor(arg_0));
        structurePlaceSettings.addProcessor((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.setRotation(Rotation.NONE);
        structurePlaceSettings.setRotationPivot(new BlockPos(1, 0, 1));
        structurePlaceSettings.setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        template.placeInWorld(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

