/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.menu;

import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.util.IDataReceiver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFilteredMenu
extends AbstractContainerMenu
implements IDataReceiver {
    protected final Inventory pinv;

    protected AbstractFilteredMenu(MenuType<?> type, int wid, Inventory pinv) {
        super(type, wid);
        this.pinv = pinv;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, ClickType click, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            ItemStack s = this.getCarried().copy();
            if (!s.isEmpty()) {
                s.setCount(1);
            }
            slot.set(s);
            return;
        }
        super.clicked(slotId, dragType, click, player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return !(slot instanceof PhantomSlot);
    }

    public void setPhantom(Slot slot, ItemStack ingredient) {
        CompoundTag tag = new CompoundTag();
        CompoundTag t = new CompoundTag();
        tag.put("setPhantom", (Tag)t);
        t.putInt("id", slot.index);
        t.put("item", ingredient.save((HolderLookup.Provider)this.pinv.player.registryAccess()));
        NetworkHandler.sendDataToServer(tag);
    }

    @Override
    public void receive(CompoundTag tag) {
        if (this.pinv.player.isSpectator()) {
            return;
        }
        if (tag.contains("setPhantom")) {
            Slot slot;
            CompoundTag t = tag.getCompound("setPhantom");
            int slotId = t.getInt("id");
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)this.pinv.player.registryAccess(), (CompoundTag)t.getCompound("item"));
            Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
            if (slot instanceof PhantomSlot && !item.isEmpty()) {
                item.setCount(1);
                slot.set(item);
            }
        }
    }
}

