/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.screen;

import com.tom.trading.TradingNetworkModClient;
import com.tom.trading.gui.PlatformContainerScreen;
import com.tom.trading.menu.VendingMachineTradingMenu;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class VendingMachineTradingScreen
extends PlatformContainerScreen<VendingMachineTradingMenu> {
    private static final ResourceLocation gui = ResourceLocation.tryBuild((String)"toms_trading_network", (String)"textures/gui/vending_machine_trading.png");
    private EditBox textF;

    public VendingMachineTradingScreen(VendingMachineTradingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    protected void renderBg(GuiGraphics gr, float pPartialTick, int pMouseX, int pMouseY) {
        gr.blit(gui, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void init() {
        super.init();
        Objects.requireNonNull(this.font);
        this.textF = new EditBox(this.font, this.leftPos + 74, this.topPos + 66, 18, 9, (Component)Component.translatable((String)"narrator.toms_trading_network.vending_machine.trade_amount"));
        this.textF.setMaxLength(100);
        this.textF.setBordered(false);
        this.textF.setVisible(true);
        this.textF.setTextColor(0xFFFFFF);
        this.textF.setValue("1");
        this.addRenderableWidget((GuiEventListener)this.textF);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.toms_trading_network.vending_machine.trade"), b -> {
            int c;
            try {
                c = Integer.parseInt(this.textF.getValue());
                if (c < 0 || c > 128) {
                    c = 1;
                }
            }
            catch (NumberFormatException e) {
                c = 1;
            }
            this.sendButtonClick(c);
        }).bounds(this.leftPos + 100, this.topPos + 60, 70, 20).build());
    }

    private void sendButtonClick(int pPageData) {
        this.minecraft.gameMode.handleInventoryButtonClick(((VendingMachineTradingMenu)this.menu).containerId, pPageData);
    }

    public void render(GuiGraphics gr, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(gr, pMouseX, pMouseY, pPartialTick);
        super.render(gr, pMouseX, pMouseY, pPartialTick);
        Slot s = this.getSlotUnderMouse();
        if (s != null && s.getContainerSlot() < 8 && (((VendingMachineTradingMenu)this.menu).matchNBT & 1 << s.getContainerSlot()) == 0) {
            TradingNetworkModClient.setTooltip(new Component[]{Component.translatable((String)"tooltip.toms_trading_network.ignoredNBT").withStyle(ChatFormatting.WHITE)});
        }
        this.renderTooltip(gr, pMouseX, pMouseY);
        TradingNetworkModClient.setTooltip(new Component[0]);
    }
}

