/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.util;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.Direction;

public enum BlockFaceDirection {
    BOTTOM(Direction.DOWN, 1, 2, -1),
    TOP(Direction.UP, 1, 0, -1),
    FRONT(Direction.SOUTH, 1, 1, 0),
    LEFT(Direction.WEST, 0, 1, 3),
    BACK(Direction.NORTH, 2, 2, 2),
    RIGHT(Direction.EAST, 2, 1, 1);

    private final Direction dir;
    private final int x;
    private final int y;
    private final int d;
    private static final BlockFaceDirection[] FACE;

    private BlockFaceDirection(Direction dir, int x, int y, int d) {
        this.dir = dir;
        this.x = x;
        this.y = y;
        this.d = d;
    }

    public Direction getHorizontalMapped(Direction blockDir) {
        if (this.dir.getAxis() == Direction.Axis.Y) {
            return this.dir;
        }
        return Direction.from2DDataValue((int)(blockDir.get2DDataValue() + this.dir.get2DDataValue()));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static BlockFaceDirection getHorizontalFace(Direction facing, Direction side) {
        if (side.getAxis() == Direction.Axis.Y) {
            return side == Direction.UP ? TOP : BOTTOM;
        }
        int f = (facing.getOpposite().get2DDataValue() - side.get2DDataValue() + 4) % 4;
        return FACE[f];
    }

    static {
        FACE = (BlockFaceDirection[])Arrays.stream(BlockFaceDirection.values()).filter(d -> d.d != -1).sorted(Comparator.comparingInt(d -> d.d)).toArray(BlockFaceDirection[]::new);
    }
}

