/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.event.ClientEventHandler;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Inject(method={"handlePlayerChat"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;disconnect(Lnet/minecraft/network/chat/Component;)V")}, cancellable=true)
    private void checkMessage(ClientboundPlayerChatPacket playerChatMessage, CallbackInfo ci) {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            Component component;
            Object message = !playerChatMessage.filterMask().isEmpty() ? ((component = playerChatMessage.filterMask().applyWithFormatting(playerChatMessage.body().content())) != null ? component : Component.empty()) : playerChatMessage.unsignedContent();
            Connectivity.LOGGER.warn("Failed chat message verification for: " + message.getString());
        }
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).disableChatVerificationDisconnect) {
            ci.cancel();
        }
    }

    @Inject(method={"sendCommand"}, at={@At(value="HEAD")})
    private void onSendCommand(String command, CallbackInfo ci) {
        ClientEventHandler.on(command);
    }

    @Inject(method={"sendUnsignedCommand"}, at={@At(value="HEAD")})
    private void onSendCommand(String command, CallbackInfoReturnable<Boolean> cir) {
        ClientEventHandler.on(command);
    }
}

