/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.IdDispatchCodec;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.ProtocolInfoBuilder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PacketDecoder.class})
public class PacketDecoderMixin<T extends PacketListener> {
    @Shadow
    @Final
    private ProtocolInfo<T> protocolInfo;

    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/jfr/JvmProfiler;onPacketReceived(Lnet/minecraft/network/ConnectionProtocol;Lnet/minecraft/network/protocol/PacketType;Ljava/net/SocketAddress;I)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void checkSize(ChannelHandlerContext p_130535_, ByteBuf buf, List<Object> p_130537_, CallbackInfo ci, int size, Packet packet) {
        if (size > 0x800000 && (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages || !((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits)) {
            PacketLogging.logPacket(packet, " received is too big: " + size + " bytes");
        }
    }

    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Ljava/io/IOException;<init>(Ljava/lang/String;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onDecode(ChannelHandlerContext p_130535_, ByteBuf buffer, List<Object> p_130537_, CallbackInfo ci, int size, Packet packet) throws IOException {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            PacketLogging.logPacket(packet, " id " + String.valueOf(packet.type()) + " larger than expected error detected, printing packet and buffer. Stacktrace gets logged after this");
            boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
            PacketLogging.logPacket(buffer.copy(buffer.readerIndex(), buffer.readableBytes()), " id " + String.valueOf(packet.type()) + " data of " + buffer.readableBytes() + " extra bytes: ");
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
        }
        throw new IOException("Packet " + this.protocolInfo.id().id() + "/" + String.valueOf(packet.type()) + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + buffer.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(packet.type()));
    }

    @Redirect(method={"decode"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/codec/StreamCodec;decode(Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object checkDecodingError(StreamCodec instance, Object o, ChannelHandlerContext p_130535_, ByteBuf buf, List<Object> result) {
        try {
            return instance.decode(o);
        }
        catch (Throwable t) {
            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                ProtocolInfoBuilder.Implementation implementation;
                StreamCodec streamCodec;
                int prevIndex = buf.readerIndex();
                buf.resetReaderIndex();
                int codecIndex = VarInt.read((ByteBuf)buf);
                Object name = "unknown";
                ProtocolInfo<T> protocolInfo = this.protocolInfo;
                if (protocolInfo instanceof ProtocolInfoBuilder.Implementation && (streamCodec = (implementation = (ProtocolInfoBuilder.Implementation)protocolInfo).codec()) instanceof IdDispatchCodec) {
                    IdDispatchCodec idDispatchCodec = (IdDispatchCodec)streamCodec;
                    name = this.protocolInfo.id().id() + "/" + String.valueOf(((IdDispatchCodec.Entry)idDispatchCodec.byId.get(codecIndex)).type());
                }
                Connectivity.LOGGER.warn("Decoding error for packet:" + (String)name, t);
                Connectivity.LOGGER.warn("<------ Packet Data Export: ------>");
                boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
                ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
                PacketLogging.logPacket(buf);
                ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
                Connectivity.LOGGER.warn("<------ Packet Data Export End: ------>");
                buf.readerIndex(prevIndex);
            }
            throw t;
        }
    }
}

