/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IInvisibleBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.INamedBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IRequirementsBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockHut<B extends AbstractBlockHut<B>>
extends AbstractBlockMinecolonies<B>
implements IBuilderUndestroyable,
IAnchorBlock,
ITickableBlockMinecolonies,
INamedBlueprintAnchorBlock,
ILeveledBlueprintAnchorBlock,
IRequirementsBlueprintAnchorBlock,
IInvisibleBlueprintAnchorBlock,
ISpecialCreativeHandlerAnchorBlock,
IBuildingBrowsableBlock {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final float HARDNESS = 10.0f;
    public static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final String name;
    private long lastBreakTickWarn = 0L;

    public AbstractBlockHut() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(10.0f, Float.POSITIVE_INFINITY).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public float getDestroyProgress(BlockState state, @NotNull Player player, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        IBuilding building = IColonyManager.getInstance().getBuilding(player.level(), pos);
        if (building != null && !building.getChildren().isEmpty() && player.level().getGameTime() - this.lastBreakTickWarn < 100L) {
            this.lastBreakTickWarn = player.level().getGameTime();
            MessageUtils.format("block.minecolonies.blockhut.breakwarn.children", new Object[0]).sendTo(player);
        }
        return ((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).pvp_mode.get() != false ? 0.025f : 0.1f) / 30.0f;
    }

    public AbstractBlockHut(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public abstract String getHutName();

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        TileEntityColonyBuilding building = (TileEntityColonyBuilding)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()).create(blockPos, blockState);
        building.registryName = this.getBuildingEntry().getRegistryName();
        return building;
    }

    public abstract BuildingEntry getBuildingEntry();

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.isClientSide) {
            TileEntityColonyBuilding te;
            if (hand == InteractionHand.OFF_HAND) {
                return ItemInteractionResult.FAIL;
            }
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.dimension(), pos);
            LevelChunk chunk = worldIn.getChunkAt(pos);
            BlockEntity entity = worldIn.getBlockEntity(pos);
            if (entity instanceof TileEntityColonyBuilding && (te = (TileEntityColonyBuilding)entity).getPositionedTags().containsKey(BlockPos.ZERO) && te.getPositionedTags().get(BlockPos.ZERO).contains("deactivated")) {
                if (building == null && ColonyUtils.getOwningColony((ChunkAccess)chunk) == 0) {
                    MessageUtils.format("com.minecolonies.coremod.building.missingcolony", new Object[0]).sendTo(player);
                    return ItemInteractionResult.FAIL;
                }
                if (building == null && ColonyUtils.getAllClaimingBuildings((ChunkAccess)chunk).values().stream().flatMap(Collection::stream).noneMatch(p -> p.equals((Object)pos))) {
                    IColonyManager.getInstance().openReactivationWindow(pos);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (building == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            if (building.getColony() == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nocolony", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            if (!building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            building.openGui(player.isShiftKeyDown());
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        @NotNull Direction facing = context.getPlayer() == null ? Direction.NORTH : Direction.fromYRot((double)context.getPlayer().getYRot());
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            IColony colony;
            @NotNull TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (hut.getBuildingName() != this.getBuildingEntry().getRegistryName()) {
                hut.registryName = this.getBuildingEntry().getRegistryName();
            }
            if ((colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition())) != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void onBlockPlacedByBuildTool(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, RotationMirror rotMir, String style, String blueprintPath) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding hut = (AbstractTileEntityColonyBuilding)tileEntity;
            hut.setRotationMirror(rotMir);
            hut.setPackName(style);
            hut.setBlueprintPath(blueprintPath);
        }
        this.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", this.getHutName());
    }

    @Override
    public B registerBlock(Registry<Block> registry) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)this);
        return (B)this;
    }

    public boolean isVisible(@Nullable CompoundTag beData) {
        Map data = IBlueprintDataProviderBE.readTagPosMapFrom((CompoundTag)beData.getCompound("blueprintDataProvider"));
        return !((List)data.getOrDefault(BlockPos.ZERO, new ArrayList())).contains("invisible");
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<MutableComponent> getRequirements(ClientLevel level, BlockPos pos, LocalPlayer player) {
        ArrayList<MutableComponent> requirements = new ArrayList<MutableComponent>();
        IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)level, pos);
        if (colonyView == null) {
            requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.hut.incolony", (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            return requirements;
        }
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), this) == -1) {
            requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.hut.cost", (Object[])new Object[]{Component.translatableEscape((String)("block.minecolonies." + this.getHutName()), (Object[])new Object[0])}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            return requirements;
        }
        ResourceLocation effectId = colonyView.getResearchManager().getResearchEffectIdFrom(this);
        if (colonyView.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return requirements;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.research.item1", (Object[])new Object[]{this.getName()}));
            requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.research.item2", (Object[])new Object[]{this.getName()}));
        }
        return requirements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean areRequirementsMet(ClientLevel level, BlockPos pos, LocalPlayer player) {
        if (player.isCreative()) {
            return true;
        }
        return this.getRequirements(level, pos, player).isEmpty();
    }

    public List<MutableComponent> getDesc() {
        ArrayList<MutableComponent> desc = new ArrayList<MutableComponent>();
        desc.add(Component.translatableEscape((String)this.getBuildingEntry().getTranslationKey(), (Object[])new Object[0]));
        desc.add(Component.translatableEscape((String)(this.getBuildingEntry().getTranslationKey() + ".desc"), (Object[])new Object[0]));
        return desc;
    }

    public Component getBlueprintDisplayName() {
        return Component.translatableEscape((String)this.getBuildingEntry().getTranslationKey(), (Object[])new Object[0]);
    }

    public int getLevel(CompoundTag beData) {
        if (beData == null) {
            return 0;
        }
        try {
            return Integer.parseInt(beData.getCompound("blueprintDataProvider").getString("schematicName").replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException exception) {
            Log.getLogger().error("Couldn't get level from hut: " + this.getHutName() + ". Potential corrubt blockEntity data.");
            return 0;
        }
    }

    public AbstractStructureHandler getStructureHandler(Level level, BlockPos blockPos, Blueprint blueprint, RotationMirror rotationMirror, boolean b) {
        return new CreativeBuildingStructureHandler(level, blockPos, blueprint, rotationMirror, b);
    }

    public boolean setup(ServerPlayer player, Level world, BlockPos pos, Blueprint blueprint, RotationMirror rotationMirror, boolean fancyPlacement, String pack, String path) {
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        if (!(anchor.getBlock() instanceof AbstractBlockHut) || !fancyPlacement && player.isCreative()) {
            return true;
        }
        if (!((Boolean)((ServerConfiguration)IMinecoloniesAPI.getInstance().getConfig().getServer()).blueprintBuildMode.get()).booleanValue() && !this.canPaste(anchor.getBlock(), (Player)player, pos)) {
            return false;
        }
        world.destroyBlock(pos, true);
        world.setBlockAndUpdate(pos, anchor);
        ((AbstractBlockHut)anchor.getBlock()).onBlockPlacedByBuildTool(world, pos, anchor, (LivingEntity)player, null, rotationMirror, pack, path);
        if (((Boolean)((ServerConfiguration)IMinecoloniesAPI.getInstance().getConfig().getServer()).blueprintBuildMode.get()).booleanValue()) {
            return true;
        }
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, pos);
        if (building == null) {
            if (anchor.getBlock() != ModBlocks.blockHutTownHall) {
                SoundUtils.playErrorSound((Player)player, player.blockPosition());
                Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                return false;
            }
        } else {
            SoundUtils.playSuccessSound((Player)player, player.blockPosition());
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.getName().getString());
                    return false;
                }
                building.getTileEntity().setColony(colony);
            }
            String adjusted = path.replace(".blueprint", "");
            String num = adjusted.substring(path.replace(".blueprint", "").length() - 2, adjusted.length() - 1);
            building.setStructurePack(pack);
            building.setBlueprintPath(path);
            try {
                building.setBuildingLevel(Integer.parseInt(num));
            }
            catch (NumberFormatException ex) {
                building.setBuildingLevel(1);
            }
            building.setRotationMirror(rotationMirror);
            building.onUpgradeComplete(building.getBuildingLevel());
        }
        return true;
    }

    private boolean canPaste(Block anchor, Player player, BlockPos pos) {
        IColony colony = IColonyManager.getInstance().getIColony(player.level(), pos);
        if (colony == null) {
            if (anchor == ModBlocks.blockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(player.level(), player) == null) {
                MessageUtils.format("tile.blockhut.messagenotownhall", new Object[0]).sendTo(player);
            } else {
                MessageUtils.format("tile.blockhut.messagetoofarfromtownhall", new Object[0]).sendTo(player);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            MessageUtils.format("tile.blockhut.messagenopermission", colony.getName()).sendTo(player);
            return false;
        }
        return colony.getBuildingManager().canPlaceAt(anchor, pos, player);
    }

    public String getBlueprintName() {
        return this.getBuildingEntry().getRegistryName().getPath();
    }

    @Override
    public void registerBlockItem(Registry<Item> registry, Item.Properties properties) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)((Object)new ItemBlockHut(this, properties)));
    }
}

