/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenMournHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.quests.IQuestGiver;
import com.minecolonies.api.quests.IQuestParticipant;
import com.minecolonies.api.util.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICitizenData
extends ICivilianData,
IQuestGiver,
IQuestParticipant {
    public static final int MAX_SATURATION = 20;

    public void onRemoveBuilding(IBuilding var1);

    @Nullable
    public IBuilding getHomeBuilding();

    public void setHomeBuilding(@Nullable IBuilding var1);

    @Nullable
    public IBuilding getWorkBuilding();

    public IJob<?> getJob();

    public void setJob(IJob<?> var1);

    @Nullable
    public <J extends IJob<?>> J getJob(@NotNull Class<J> var1);

    public void setLastPosition(BlockPos var1);

    public BlockPos getLastPosition();

    public void setSaturation(double var1);

    public boolean isAsleep();

    public BlockPos getBedPos();

    public void setAsleep(boolean var1);

    public void setBedPos(BlockPos var1);

    public ICitizenHappinessHandler getCitizenHappinessHandler();

    public ICitizenMournHandler getCitizenMournHandler();

    public ICitizenSkillHandler getCitizenSkillHandler();

    public ICitizenDiseaseHandler getCitizenDiseaseHandler();

    public void scheduleRestart(ServerPlayer var1);

    public boolean shouldRestart();

    public void restartDone();

    public void setIsChild(boolean var1);

    public boolean justAte();

    public void setJustAte(boolean var1);

    public boolean isIdleAtJob();

    public void setIdleAtJob(boolean var1);

    public Optional<AbstractEntityCitizen> getEntity();

    public VisibleCitizenStatus getStatus();

    public void setVisibleStatus(VisibleCitizenStatus var1);

    @Nullable
    public BlockPos getStatusPosition();

    public void setStatusPosition(@Nullable BlockPos var1);

    public Random getRandom();

    public void applyResearchEffects();

    public void onGoSleep();

    public void setNextRespawnPosition(BlockPos var1);

    public boolean needsBetterFood();

    @Nullable
    public ICitizenData getPartner();

    public List<Integer> getChildren();

    public List<Integer> getSiblings();

    public Tuple<String, String> getParents();

    public void addSiblings(Integer ... var1);

    public void addChildren(Integer ... var1);

    public void setPartner(int var1);

    public void onDeath(Integer var1);

    public void setParents(String var1, String var2);

    public void generateName(@NotNull Random var1, String var2, String var3, CitizenNameFile var4);

    public boolean isRelatedTo(ICitizenData var1);

    public boolean doesLiveWith(ICitizenData var1);

    default public void setWorking(boolean b) {
    }

    default public boolean isWorking() {
        return true;
    }

    public void onResurrect();

    default public boolean hasCustomTexture() {
        return false;
    }

    public void setCustomTexture(UUID var1);

    public UUID getCustomTexture();

    public void setIdleDays(int var1);

    public void onQuestCompletion(ResourceLocation var1);

    public void onInteractionClosed(Component var1, ServerPlayer var2);

    public void onBuildingLoad();

    public void setInteractedRecently(UUID var1);

    public boolean hasQuestAssignment();

    @Nullable
    public BlockPos getHomePosition();

    public double getDiseaseModifier();

    public ICitizenFoodHandler getCitizenFoodHandler();
}

