/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRecipe
implements IGenericRecipe {
    @Nullable
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<ItemStack> allMultiOutputs;
    private final List<ItemStack> additionalOutputs;
    private final List<List<ItemStack>> inputs;
    private final int gridSize;
    private final Block intermediate;
    @Nullable
    private final ResourceKey<LootTable> lootTable;
    private final EquipmentTypeEntry requiredTool;
    private final EntityType<?> requiredEntity;
    private final List<Component> restrictions;
    private final int levelSort;

    @Nullable
    public static IGenericRecipe of(@Nullable RecipeHolder<?> holder, @NotNull Level world) {
        Block intermediate;
        int size;
        if (holder == null) {
            return null;
        }
        Recipe recipe = holder.value();
        List<List<ItemStack>> inputs = GenericRecipe.compactInputs(recipe.getIngredients().stream().map(ingredient -> Arrays.asList(ingredient.getItems())).collect(Collectors.toList()));
        if (recipe instanceof SmeltingRecipe) {
            size = 1;
            intermediate = Blocks.FURNACE;
        } else {
            size = recipe.canCraftInDimensions(2, 2) ? 2 : 3;
            intermediate = Blocks.AIR;
        }
        return new GenericRecipe(holder.id(), recipe.getResultItem((HolderLookup.Provider)world.registryAccess()), GenericRecipe.calculateSecondaryOutputs(recipe, world), inputs, size, intermediate, null, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), new ArrayList<Component>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage, @NotNull List<Component> restrictions, int levelSort) {
        if (storage == null) {
            return null;
        }
        List<List<ItemStack>> inputs = storage.getCleanedInput().stream().map(input -> Collections.singletonList(GenericRecipe.toItemStack(input))).collect(Collectors.toList());
        return new GenericRecipe(storage.getRecipeSource(), storage.getPrimaryOutput(), storage.getAlternateOutputs(), storage.getSecondaryOutputs(), inputs, storage.getGridSize(), storage.getIntermediate(), storage.getLootTable(), storage.getRequiredTool(), null, restrictions, levelSort);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage) {
        return GenericRecipe.of(storage, new ArrayList<Component>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IToken<?> recipeToken) {
        if (recipeToken == null) {
            return null;
        }
        return GenericRecipe.of((IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken));
    }

    public GenericRecipe(@Nullable ResourceLocation id, @NotNull ItemStack output, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceKey<LootTable> lootTable, @NotNull EquipmentTypeEntry requiredTool, @NotNull List<Component> restrictions, int levelSort) {
        this.id = id == null || id.getPath().isEmpty() ? null : id;
        this.output = output;
        this.allMultiOutputs = Collections.singletonList(output);
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.requiredTool = requiredTool;
        this.requiredEntity = null;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    public GenericRecipe(@Nullable ResourceLocation id, @NotNull ItemStack output, @NotNull List<ItemStack> altOutputs, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceKey<LootTable> lootTable, @NotNull EquipmentTypeEntry requiredTool, @Nullable EntityType<?> requiredEntity, @NotNull List<Component> restrictions, int levelSort) {
        this.id = id;
        this.output = output;
        this.allMultiOutputs = Stream.concat(Stream.of(output), altOutputs.stream()).filter(ItemStackUtils::isNotEmpty).toList();
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.requiredTool = requiredTool;
        this.requiredEntity = requiredEntity;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.allMultiOutputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public List<Component> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public int getLevelSort() {
        return this.levelSort;
    }

    @Override
    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return predicate.test(this.output);
    }

    @Override
    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        Optional<Boolean> result = Optional.empty();
        for (List<ItemStack> slot : this.inputs) {
            for (ItemStack stack : slot) {
                Optional<Boolean> itemResult = predicate.test(stack);
                if (!itemResult.isPresent()) continue;
                if (!itemResult.get().booleanValue()) {
                    return itemResult;
                }
                result = itemResult;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.requiredTool;
    }

    @Override
    @Nullable
    public EntityType<?> getRequiredEntity() {
        return this.requiredEntity;
    }

    public String toString() {
        return "GenericRecipe{output=" + String.valueOf(this.output) + "}";
    }

    @NotNull
    private static ItemStack toItemStack(@NotNull ItemStorage input) {
        ItemStack result = input.getItemStack().copy();
        result.setCount(input.getAmount());
        return result;
    }

    @NotNull
    private static List<ItemStack> calculateSecondaryOutputs(@NotNull Recipe<?> recipe, @Nullable Level world) {
        if (recipe instanceof CraftingRecipe) {
            NonNullList inputs = recipe.getIngredients();
            TransientCraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(MenuType.CRAFTING, 0){

                @NotNull
                public ItemStack quickMoveStack(@NotNull Player player, int slot) {
                    return ItemStack.EMPTY;
                }

                public boolean stillValid(@NotNull Player playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int slot = 0; slot < inputs.size(); ++slot) {
                ItemStack[] stacks = ((Ingredient)inputs.get(slot)).getItems();
                if (stacks.length <= 0) continue;
                inv.setItem(slot, stacks[0].copy());
            }
            if (((CraftingRecipe)recipe).matches((RecipeInput)inv.asCraftInput(), world)) {
                return ((CraftingRecipe)recipe).getRemainingItems((RecipeInput)inv.asCraftInput()).stream().filter(ItemStackUtils::isNotEmpty).filter(stack -> stack.getItem() != ModItems.buildTool.get()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static List<List<ItemStack>> compactInputs(List<List<ItemStack>> inputs) {
        HashMap<IngredientStacks, IngredientStacks> ingredients = new HashMap<IngredientStacks, IngredientStacks>();
        for (List<ItemStack> ingredient : inputs) {
            IngredientStacks newIngredient = new IngredientStacks(ingredient);
            if (!newIngredient.getStacks().isEmpty() && newIngredient.getStacks().get(0).getItem() == ModItems.buildTool.get()) continue;
            IngredientStacks existing = (IngredientStacks)ingredients.get(newIngredient);
            if (existing == null) {
                ingredients.put(newIngredient, newIngredient);
                continue;
            }
            existing.merge(newIngredient);
        }
        return ingredients.values().stream().sorted(Comparator.reverseOrder()).map(IngredientStacks::getStacks).collect(Collectors.toList());
    }

    private static class IngredientStacks
    implements Comparable<IngredientStacks> {
        private final List<ItemStack> stacks;
        private final List<Item> items;

        public IngredientStacks(List<ItemStack> ingredient) {
            this.stacks = new ArrayList<ItemStack>(ingredient.size());
            this.items = new ArrayList<Item>(ingredient.size());
            for (ItemStack stack : ingredient) {
                if (stack.isEmpty()) continue;
                ItemStack copy = stack.copy();
                this.stacks.add(copy);
                Item item = copy.getItem();
                this.items.add(item);
            }
        }

        @NotNull
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public int getCount() {
            return this.stacks.isEmpty() ? 0 : this.stacks.get(0).getCount();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientStacks that = (IngredientStacks)o;
            return this.items.equals(that.items);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public int compareTo(@NotNull IngredientStacks o) {
            int diff = this.getCount() - o.getCount();
            if (diff != 0) {
                return diff;
            }
            diff = this.stacks.size() - o.stacks.size();
            if (diff != 0) {
                return diff;
            }
            return this.hashCode() - o.hashCode();
        }

        public void merge(@NotNull IngredientStacks other) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.get(i).grow(other.stacks.get(i).getCount());
            }
        }

        public String toString() {
            return "IngredientStacks{stacks=" + String.valueOf(this.stacks) + ", items=" + String.valueOf(this.items) + "}";
        }
    }
}

