/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.api.entity.ai.statemachine.basestatemachine.BasicTransition;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickingTransition;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TickingTransition<S extends IState>
extends BasicTransition<S>
implements ITickingTransition<S> {
    private int tickRate;
    private int ticksToUpdate = 0;
    private static int tickOffsetVariant = 0;

    public TickingTransition(@NotNull S state, @NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState, int tickRate) {
        super(state, condition, nextState);
        this.tickRate = Math.min(tickRate, 500);
        this.tickRate = Math.max(this.tickRate, 1);
        this.ticksToUpdate = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    public TickingTransition(@NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState, int tickRate) {
        super(condition, nextState);
        this.tickRate = Math.min(tickRate, 500);
        this.tickRate = Math.max(this.tickRate, 1);
        this.ticksToUpdate = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    @Override
    public int countdownTicksToUpdate(int reduction) {
        return this.ticksToUpdate -= reduction;
    }

    @Override
    public void setTicksToUpdate(int ticksToUpdate) {
        this.ticksToUpdate = ticksToUpdate;
    }
}

