/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.util.Utils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractResearchProvider
implements DataProvider {
    protected final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> providerFuture;
    protected HolderLookup.Provider provider;
    private final List<Tuple<JsonObject, Tuple<String, String>>> research = new ArrayList<Tuple<JsonObject, Tuple<String, String>>>();

    public AbstractResearchProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> provider) {
        this.packOutput = packOutput;
        this.providerFuture = provider;
    }

    protected abstract Collection<ResearchBranch> getResearchBranchCollection();

    protected abstract Collection<ResearchEffect> getResearchEffectCollection();

    protected abstract Collection<Research> getResearchCollection();

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.providerFuture.thenCompose(p -> {
            this.provider = p;
            JsonObject langJson = new JsonObject();
            for (ResearchBranch branch : this.getResearchBranchCollection()) {
                this.research.add((Tuple<JsonObject, Tuple<String, String>>)new Tuple((Object)branch.json, (Object)new Tuple((Object)branch.id.getNamespace(), (Object)branch.id.getPath())));
                if (branch.translatedName != null && !branch.translatedName.isEmpty()) {
                    this.addLanguageKeySafe((JsonElement)langJson, "com." + branch.id.getNamespace() + ".research." + branch.id.getPath().replaceAll("[/]", ".") + ".name", branch.translatedName);
                }
                if (branch.translatedSubtitle == null || branch.translatedSubtitle.isEmpty()) continue;
                this.addLanguageKeySafe((JsonElement)langJson, "com." + branch.id.getNamespace() + ".research." + branch.id.getPath().replaceAll("[/]", ".") + ".subtitle", branch.translatedSubtitle);
            }
            for (ResearchEffect effect : this.getResearchEffectCollection()) {
                this.research.add((Tuple<JsonObject, Tuple<String, String>>)new Tuple((Object)effect.json, (Object)new Tuple((Object)effect.id.getNamespace(), (Object)effect.id.getPath())));
                if (effect.translatedName != null && !effect.translatedName.isEmpty()) {
                    this.addLanguageKeySafe((JsonElement)langJson, "com." + effect.id.getNamespace() + ".research." + effect.id.getPath().replaceAll("[/]", ".") + ".description", effect.translatedName);
                }
                if (effect.translatedSubtitle == null || effect.translatedSubtitle.isEmpty()) continue;
                this.addLanguageKeySafe((JsonElement)langJson, "com." + effect.id.getNamespace() + ".research." + effect.id.getPath().replaceAll("[/]", ".") + ".subtitle", effect.translatedSubtitle);
            }
            for (Research research : this.getResearchCollection()) {
                this.research.add((Tuple<JsonObject, Tuple<String, String>>)new Tuple((Object)research.json, (Object)new Tuple((Object)research.id.getNamespace(), (Object)research.id.getPath())));
                if (research.translatedName != null && !research.translatedName.isEmpty()) {
                    this.addLanguageKeySafe((JsonElement)langJson, "com." + research.id.getNamespace() + ".research." + research.id.getPath().replaceAll("[/]", ".") + ".name", research.translatedName);
                }
                if (research.translatedSubtitle == null || research.translatedSubtitle.isEmpty()) continue;
                this.addLanguageKeySafe((JsonElement)langJson, "com." + research.id.getNamespace() + ".research." + research.id.getPath().replaceAll("[/]", ".") + ".subtitle", research.translatedSubtitle);
            }
            return this.generateAll(cache, langJson);
        });
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache, JsonObject langJson) {
        CompletableFuture[] futures = new CompletableFuture[this.research.size() + 1];
        int i = 0;
        PackOutput.PathProvider langPath = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
        PackOutput.PathProvider researchesPath = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "researches");
        for (Tuple<JsonObject, Tuple<String, String>> model : this.research) {
            Path target = researchesPath.json(new ResourceLocation((String)((Tuple)model.getB()).getA(), (String)((Tuple)model.getB()).getB()));
            futures[i++] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)model.getA()), (Path)target);
        }
        futures[i] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)langJson, (Path)langPath.json(new ResourceLocation("minecolonies", "default")));
        return CompletableFuture.allOf(futures);
    }

    private void addLanguageKeySafe(JsonElement langJson, String key, String property) {
        if (langJson.getAsJsonObject().has(key)) {
            langJson.getAsJsonObject().remove(key);
        }
        langJson.getAsJsonObject().addProperty(key, property);
    }

    @NotNull
    public String getName() {
        return "Research Data Provider";
    }

    protected static class ResearchBranch {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public String translatedName;
        public String translatedSubtitle;

        public ResearchBranch(ResourceLocation id) {
            this.id = id;
        }

        public ResearchBranch setBranchName(String branchName) {
            this.json.addProperty("branch-name", branchName);
            return this;
        }

        public ResearchBranch setTranslatedBranchName(String translatedBranchName) {
            this.translatedName = translatedBranchName;
            this.json.addProperty("branch-name", "com." + this.id.getNamespace() + ".research." + this.id.getPath().replaceAll("[ /]", ".") + ".name");
            return this;
        }

        public ResearchBranch setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public ResearchBranch setTranslatedSubtitle(String translatedSubtitle) {
            this.translatedSubtitle = translatedSubtitle;
            this.json.addProperty("subtitle", "com." + this.id.getNamespace() + ".research." + this.id.getPath().replaceAll("[ /]", ".") + ".subtitle");
            return this;
        }

        public ResearchBranch setBranchTimeMultiplier(double branchTimeMultiplier) {
            this.json.addProperty("base-time", (Number)branchTimeMultiplier);
            return this;
        }

        public ResearchBranch setBranchType(ResearchBranchType type) {
            this.json.addProperty("branch-type", type.tag);
            return this;
        }

        public ResearchBranch setBranchSortOrder(int sortOrder) {
            this.json.addProperty("sortOrder", (Number)sortOrder);
            return this;
        }

        public ResearchBranch setHidden(boolean hidden) {
            this.json.addProperty("hidden", Boolean.valueOf(hidden));
            return this;
        }

        public ResearchBranch setRemove() {
            this.json.addProperty("base-time", (Number)1.0);
            this.json.addProperty("remove", Boolean.valueOf(true));
            return this;
        }

        public ResearchBranch setRemove(ResourceLocation branchId) {
            this.json.addProperty("base-time", (Number)1.0);
            this.json.addProperty("remove", branchId.toString());
            return this;
        }

        public ResearchBranch setRemove(Collection<ResourceLocation> branchIds) {
            this.json.addProperty("base-time", (Number)1.0);
            JsonArray removes = new JsonArray();
            for (ResourceLocation rem : branchIds) {
                removes.add(rem.toString());
            }
            this.json.add("remove", (JsonElement)removes);
            return this;
        }
    }

    protected static class ResearchEffect {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public String translatedName;
        public String translatedSubtitle;

        public ResearchEffect(ResourceLocation id) {
            this.id = id;
            this.json.addProperty("effect", Boolean.valueOf(true));
        }

        public ResearchEffect(AbstractBlockHut<?> buildingBlock) {
            ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey(buildingBlock);
            this.id = new ResourceLocation(registryName.getNamespace(), "effects/" + registryName.getPath());
            this.json.addProperty("effect", Boolean.valueOf(true));
        }

        public ResearchEffect(ResourceLocation id, String type) {
            this.id = id;
            this.json.addProperty("effect", Boolean.valueOf(true));
            this.json.addProperty("effectType", type);
        }

        public ResearchEffect setLevels(double[] strengths) {
            JsonArray child = new JsonArray();
            for (double str : strengths) {
                child.add((Number)str);
            }
            this.json.add("levels", (JsonElement)child);
            return this;
        }

        public ResearchEffect setName(String name) {
            this.json.addProperty("name", name);
            return this;
        }

        public ResearchEffect setTranslatedName(String name) {
            this.translatedName = name;
            return this;
        }

        public ResearchEffect setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public ResearchEffect setTranslatedSubtitle(String subtitle) {
            this.translatedSubtitle = subtitle;
            this.json.addProperty("subtitle", "com." + this.id.getNamespace() + ".research." + this.id.getPath().replaceAll("[/]", ".") + ".subtitle");
            return this;
        }
    }

    protected static class Research {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public int researchLevel;
        public String translatedName;
        public String translatedSubtitle;

        public Research(ResourceLocation id, ResourceLocation branch) {
            this.id = id;
            this.researchLevel = 1;
            this.json.addProperty("branch", branch.toString());
            this.json.addProperty("researchLevel", (Number)1);
        }

        public Research setParentResearch(Research parent) {
            this.json.addProperty("parentResearch", parent.id.toString());
            this.json.remove("researchLevel");
            this.researchLevel = parent.researchLevel + 1;
            this.json.addProperty("researchLevel", (Number)this.researchLevel);
            return this;
        }

        public Research setName(String name) {
            this.json.addProperty("name", name);
            return this;
        }

        public Research setTranslatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public Research setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public Research setTranslatedSubtitle(String translatedSubtitle) {
            this.translatedSubtitle = translatedSubtitle;
            this.json.addProperty("subtitle", "com." + this.id.getNamespace() + ".research." + this.id.getPath().replaceAll("[ /]", ".") + ".subtitle");
            return this;
        }

        public Research setSortOrder(int sortNum) {
            this.json.addProperty("sortOrder", (Number)sortNum);
            return this;
        }

        public Research setOnlyChild() {
            this.json.addProperty("exclusiveChildResearch", Boolean.valueOf(true));
            return this;
        }

        public Research setNoReset() {
            this.json.addProperty("no-reset", Boolean.valueOf(true));
            return this;
        }

        public Research setAutostart() {
            this.json.addProperty("autostart", Boolean.valueOf(true));
            return this;
        }

        public Research setInstant() {
            this.json.addProperty("instant", Boolean.valueOf(true));
            return this;
        }

        public Research setHidden() {
            this.json.addProperty("hidden", Boolean.valueOf(true));
            return this;
        }

        public Research setIcon(ItemStack item) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString() + ":" + item.getCount());
            return this;
        }

        public Research setIcon(Item item) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", BuiltInRegistries.ITEM.getKey((Object)item).toString());
            return this;
        }

        public Research setIcon(Item item, int count) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", BuiltInRegistries.ITEM.getKey((Object)item).toString() + ":" + count);
            return this;
        }

        public Research setIcon(ResourceLocation texture) {
            this.json.addProperty("icon", texture.toString());
            return this;
        }

        private JsonObject makeSafeBuildingProperty(String propertyType, String buildingName, int level) {
            JsonObject req = new JsonObject();
            req.addProperty(propertyType, buildingName);
            req.addProperty("level", (Number)level);
            return req;
        }

        public Research addBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addMandatoryBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("mandatory-building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addAlternateBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("alternate-building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addResearchRequirement(ResourceLocation researchReq) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("research", researchReq.toString());
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addResearchRequirement(ResourceLocation researchReq, String name) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("research", researchReq.toString());
            req.addProperty("name", name);
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addItemCost(Item item, int count, HolderLookup.Provider provider) {
            return this.addItemCost(SizedIngredient.of((ItemLike)item, (int)count), provider);
        }

        public Research addItemCost(TagKey<Item> tag, int count, HolderLookup.Provider provider) {
            return this.addItemCost(SizedIngredient.of(tag, (int)count), provider);
        }

        public Research addItemCost(SizedIngredient item, HolderLookup.Provider provider) {
            return this.addItemCost(List.of(item), provider);
        }

        public Research addItemCost(List<SizedIngredient> items, HolderLookup.Provider provider) {
            JsonArray reqArray = this.getRequirementsArray();
            if (items.isEmpty()) {
                return this;
            }
            JsonElement itemJson = items.size() == 1 ? Utils.serializeCodecMessToJson(SizedIngredient.FLAT_CODEC, provider, items.getFirst()) : Utils.serializeCodecMessToJson(SizedIngredient.FLAT_CODEC.listOf(), provider, items);
            JsonObject req = new JsonObject();
            req.add("items", itemJson);
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        private JsonArray getRequirementsArray() {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            return reqArray;
        }

        public Research addEffect(ResourceLocation effect, int level) {
            JsonArray effects;
            if (this.json.has("effects") && this.json.get("effects").isJsonArray()) {
                effects = this.json.getAsJsonArray("effects");
                this.json.remove("effects");
            } else {
                effects = new JsonArray();
            }
            JsonObject eff = new JsonObject();
            eff.addProperty(effect.toString(), (Number)level);
            effects.add((JsonElement)eff);
            this.json.add("effects", (JsonElement)effects);
            return this;
        }

        public Research addEffect(AbstractBlockHut<?> buildingBlock, int level) {
            JsonArray effects;
            if (this.json.has("effects") && this.json.get("effects").isJsonArray()) {
                effects = this.json.getAsJsonArray("effects");
                this.json.remove("effects");
            } else {
                effects = new JsonArray();
            }
            ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey(buildingBlock);
            JsonObject eff = new JsonObject();
            eff.addProperty(registryName.getNamespace() + ":effects/" + registryName.getPath(), (Number)level);
            effects.add((JsonElement)eff);
            this.json.add("effects", (JsonElement)effects);
            return this;
        }

        public Research setRemove() {
            this.json.addProperty("remove", Boolean.valueOf(true));
            return this;
        }

        public Research setRemove(ResourceLocation researchId) {
            this.json.addProperty("remove", researchId.toString());
            return this;
        }

        public Research setRemove(Collection<ResourceLocation> researchIds) {
            JsonArray removes = new JsonArray();
            for (ResourceLocation rem : researchIds) {
                removes.add(rem.toString());
            }
            this.json.add("remove", (JsonElement)removes);
            return this;
        }

        public Research addToList(Collection<Research> list) {
            list.add(this);
            return this;
        }
    }
}

