/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.registry;

import com.minecolonies.api.research.IResearchRequirement;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ResearchRequirementEntry {
    private final Function<CompoundTag, IResearchRequirement> readFromNBT;
    private final ResourceLocation registryname;

    public IResearchRequirement readFromNBT(CompoundTag nbt) {
        return this.readFromNBT.apply(nbt);
    }

    private ResearchRequirementEntry(Function<CompoundTag, IResearchRequirement> readFromNBT, ResourceLocation registryName) {
        this.readFromNBT = readFromNBT;
        this.registryname = registryName;
    }

    public ResourceLocation getRegistryName() {
        return this.registryname;
    }

    public static final class Builder {
        private Function<CompoundTag, IResearchRequirement> readFromNBT;
        private ResourceLocation registryName;

        public Builder setReadFromNBT(Function<CompoundTag, IResearchRequirement> readFromNBT) {
            this.readFromNBT = readFromNBT;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public ResearchRequirementEntry createResearchRequirementEntry() {
            Objects.requireNonNull(this.readFromNBT);
            Objects.requireNonNull(this.registryName);
            return new ResearchRequirementEntry(this.readFromNBT, this.registryName);
        }
    }
}

