/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;

public class LookHandler
extends LookControl {
    private boolean doneNavigating = true;
    private Entity lookingAt = null;
    private int lookAtTimer = 0;

    public LookHandler(Mob entity) {
        super(entity);
    }

    public void tick() {
        if (this.mob.tickCount % 20 == 17) {
            this.doneNavigating = this.mob.getNavigation().isDone();
        }
        if (this.lookingAt != null && this.lookAtTimer-- > 0) {
            super.setLookAt(this.lookingAt);
            if (this.lookAtTimer == 0) {
                this.lookingAt = null;
            }
        }
        if (this.resetXRotOnTick()) {
            this.mob.setXRot(0.0f);
        }
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            double dx = this.wantedX - this.mob.getX();
            double dz = this.wantedZ - this.mob.getZ();
            if (Math.abs(dz) > (double)1.0E-5f || Math.abs(dx) > (double)1.0E-5f) {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875) - 90.0f, this.yMaxRotSpeed);
            }
            double dEy = this.wantedY - this.mob.getEyeY();
            double xzlenght = Math.sqrt(dx * dx + dz * dz);
            if (Math.abs(dEy) > (double)1.0E-5f || Math.abs(xzlenght) > (double)1.0E-5f) {
                this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), (float)(-(Mth.atan2((double)dEy, (double)xzlenght) * 57.2957763671875)), this.xMaxRotAngle));
            }
        } else {
            this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, 10.0f);
        }
        if (!this.doneNavigating) {
            this.mob.yHeadRot = Mth.rotateIfNecessary((float)this.mob.yHeadRot, (float)this.mob.yBodyRot, (float)this.mob.getMaxHeadYRot());
        }
    }

    public void setLookAtCooldown(int cooldown) {
        this.lookAtCooldown = cooldown;
    }

    public void setLookAt(Entity entity) {
        super.setLookAt(entity);
        this.lookAtTimer = 100;
        this.lookingAt = entity;
    }

    public void setLookAt(Entity entity, float turnY, float turnX) {
        super.setLookAt(entity, turnY, turnX);
        this.lookAtTimer = 100;
        this.lookingAt = entity;
    }
}

