/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.BambooPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.CactusPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.CocoaPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.CrimsonPlantsPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.GlowBerriesPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.KelpPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.SeagrassPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.SeapicklePlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.SugarCanePlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.TwistingVinesPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.VinePlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.WarpedPlantsPlantModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific.WeepingVinesPlantModule;
import com.minecolonies.core.colony.fields.FarmField;
import com.minecolonies.core.colony.fields.PlantationField;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModFieldsInitializer {
    public static final DeferredRegister<FieldRegistries.FieldEntry> DEFERRED_REGISTER = DeferredRegister.create(CommonMinecoloniesAPIImpl.FIELDS, (String)"minecolonies");

    private ModFieldsInitializer() {
        throw new IllegalStateException("Tried to initialize: ModFieldsInitializer but this is a Utility class.");
    }

    private static DeferredHolder<FieldRegistries.FieldEntry, FieldRegistries.FieldEntry> createEntry(ResourceLocation registryName, Consumer<FieldRegistries.FieldEntry.Builder> builder) {
        FieldRegistries.FieldEntry.Builder field = new FieldRegistries.FieldEntry.Builder().setRegistryName(registryName);
        builder.accept(field);
        return DEFERRED_REGISTER.register(registryName.getPath(), field::createFieldEntry);
    }

    static {
        FieldRegistries.farmField = ModFieldsInitializer.createEntry(FieldRegistries.FARM_FIELD_ID, builder -> builder.setFieldProducer(FarmField::new));
        FieldRegistries.plantationSugarCaneField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_SUGAR_CANE_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new SugarCanePlantModule((IField)field, "sugar_field", "sugar", Items.SUGAR_CANE)));
        FieldRegistries.plantationCactusField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_CACTUS_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new CactusPlantModule((IField)field, "cactus_field", "cactus", Items.CACTUS)));
        FieldRegistries.plantationBambooField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_BAMBOO_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new BambooPlantModule((IField)field, "bamboo_field", "bamboo", Items.BAMBOO)));
        FieldRegistries.plantationCocoaBeansField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_COCOA_BEANS_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new CocoaPlantModule((IField)field, "cocoa_field", "cocoa", Items.COCOA_BEANS)));
        FieldRegistries.plantationVinesField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_VINES_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new VinePlantModule((IField)field, "vine_field", "vine", Items.VINE)));
        FieldRegistries.plantationKelpField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_KELP_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new KelpPlantModule((IField)field, "kelp_field", "kelp", Items.KELP)));
        FieldRegistries.plantationSeagrassField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_SEAGRASS_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new SeagrassPlantModule((IField)field, "seagrass_field", "seagrass", Items.SEAGRASS)));
        FieldRegistries.plantationSeaPicklesField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_SEA_PICKLES_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new SeapicklePlantModule((IField)field, "seapickle_field", "seapickle", Items.SEA_PICKLE)));
        FieldRegistries.plantationGlowberriesField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_GLOWBERRIES_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new GlowBerriesPlantModule((IField)field, "glowb_field", "glowb_vine", Items.GLOW_BERRIES)));
        FieldRegistries.plantationWeepingVinesField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_WEEPING_VINES_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new WeepingVinesPlantModule((IField)field, "weepv_field", "weepv_vine", Items.WEEPING_VINES)));
        FieldRegistries.plantationTwistingVinesField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_TWISTING_VINES_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new TwistingVinesPlantModule((IField)field, "twistv_field", "twistv_vine", Items.TWISTING_VINES)));
        FieldRegistries.plantationCrimsonPlantsField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_CRIMSON_PLANTS_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new CrimsonPlantsPlantModule((IField)field, "crimsonp_field", "crimsonp_ground", Items.CRIMSON_FUNGUS)));
        FieldRegistries.plantationWarpedPlantsField = ModFieldsInitializer.createEntry(FieldRegistries.PLANTATION_WARPED_PLANTS_FIELD_ID, builder -> builder.setFieldProducer(PlantationField::new).addFieldModuleProducer(field -> new WarpedPlantsPlantModule((IField)field, "warpedp_field", "warpedp_ground", Items.WARPED_FUNGUS)));
    }
}

