/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.core.colony.fields.PlantationField;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PlantationFieldsModuleWindow
extends AbstractModuleWindow {
    private static final String HUT_FIELDS_RESOURCE_SUFFIX = ":gui/layouthuts/layoutplantationfields.xml";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_BUTTON_ASSIGN = "assign";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String TAG_FIELD_COUNT = "fieldCount";
    private static final String TAG_PLANT_COUNT = "plantCount";
    private static final String TAG_ICON = "icon";
    private static final String TEXTURE_ASSIGN_ON_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini_check.png";
    private static final String TEXTURE_ASSIGN_ON_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled_check.png";
    private static final String TEXTURE_ASSIGN_OFF_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini.png";
    private static final String TEXTURE_ASSIGN_OFF_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled.png";
    private final BuildingPlantation.PlantationFieldsModuleView moduleView;
    private ScrollingList fieldList;

    public PlantationFieldsModuleWindow(IBuildingView building, BuildingPlantation.PlantationFieldsModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutplantationfields.xml");
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
        this.moduleView = moduleView;
    }

    private void assignmentModeClicked(@NotNull Button button) {
        this.moduleView.setAssignFieldManually(!this.moduleView.assignFieldManually());
        this.updateUI();
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        IField field = this.moduleView.getFields().get(row);
        if (field.isTaken()) {
            this.moduleView.freeField(field);
        } else {
            this.moduleView.assignField(field);
        }
        this.updateUI();
    }

    private void updateUI() {
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.translatableEscape((String)(this.moduleView.assignFieldManually() ? "com.minecolonies.coremod.gui.hiring.on" : "com.minecolonies.coremod.gui.hiring.off"), (Object[])new Object[0]));
        ((Text)this.findPaneOfTypeByID(TAG_FIELD_COUNT, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount", (Object[])new Object[]{this.moduleView.getOwnedFields().size(), this.moduleView.getMaxFieldCount()}));
        ((Text)this.findPaneOfTypeByID(TAG_PLANT_COUNT, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.plantcount", (Object[])new Object[]{this.moduleView.getCurrentPlants(), this.moduleView.getMaxConcurrentPlants()}));
    }

    public void onOpened() {
        super.onOpened();
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return PlantationFieldsModuleWindow.this.moduleView.getFields().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                PlantationField field = (PlantationField)PlantationFieldsModuleWindow.this.moduleView.getFields().get(index);
                Item item = field.getModule().getItem();
                ((ItemIcon)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(new ItemStack((ItemLike)item));
                String distance = Integer.toString(field.getSqDistance(PlantationFieldsModuleWindow.this.buildingView));
                BlockPosUtil.DirectionResult direction = BlockPosUtil.calcDirection(PlantationFieldsModuleWindow.this.buildingView.getPosition(), field.getPosition());
                Component directionText = switch (direction) {
                    case BlockPosUtil.DirectionResult.SAME -> Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.plantation.direction.exact", (Object[])new Object[0]);
                    case BlockPosUtil.DirectionResult.UP, BlockPosUtil.DirectionResult.DOWN -> direction.getLongText();
                    default -> Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.distance", (Object[])new Object[]{Component.literal((String)(distance + "m")), direction.getShortText()});
                };
                ((Text)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText(directionText);
                ButtonImage assignButton = (ButtonImage)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_BUTTON_ASSIGN, ButtonImage.class);
                assignButton.setEnabled(PlantationFieldsModuleWindow.this.moduleView.assignFieldManually());
                assignButton.show();
                assignButton.setHoverPane(null);
                if (field.isTaken()) {
                    PlantationFieldsModuleWindow.this.setAssignButtonTexture(assignButton, true);
                } else {
                    PlantationFieldsModuleWindow.this.setAssignButtonTexture(assignButton, false);
                    if (!PlantationFieldsModuleWindow.this.moduleView.canAssignField(field)) {
                        assignButton.disable();
                        MutableComponent warningTooltip = PlantationFieldsModuleWindow.this.moduleView.getFieldWarningTooltip(field);
                        if (warningTooltip != null && PlantationFieldsModuleWindow.this.moduleView.assignFieldManually()) {
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(warningTooltip.withStyle(ChatFormatting.RED))).hoverPane((Pane)assignButton).build();
                        }
                    }
                }
            }
        });
        this.updateUI();
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateUI();
    }

    private void setAssignButtonTexture(ButtonImage button, boolean isOn) {
        if (isOn) {
            button.setImage(ResourceLocation.parse((String)TEXTURE_ASSIGN_ON_NORMAL));
            button.setImageDisabled(ResourceLocation.parse((String)TEXTURE_ASSIGN_ON_DISABLED));
        } else {
            button.setImage(ResourceLocation.parse((String)TEXTURE_ASSIGN_OFF_NORMAL));
            button.setImageDisabled(ResourceLocation.parse((String)TEXTURE_ASSIGN_OFF_DISABLED));
        }
    }
}

