/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.MinerLevelManagementModuleView;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerRepairLevelMessage;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutMinerModule
extends AbstractModuleWindow {
    private static final String LIST_LEVELS = "levels";
    private static final String BUTTON_CURRENTLEVEL = "changeToLevel";
    private static final String BUTTON_REPAIR = "repair";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutminermodule.xml";
    private final MinerLevelManagementModuleView miner;
    private List<Tuple<Integer, Integer>> levelsInfo;
    private ScrollingList levelList;

    public WindowHutMinerModule(IBuildingView building, MinerLevelManagementModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutminermodule.xml");
        this.miner = moduleView;
        this.pullLevelsFromHut();
        this.registerButton(BUTTON_CURRENTLEVEL, this::currentLevelClicked);
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
    }

    private void repairClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        new MinerRepairLevelMessage(this.buildingView, row).sendToServer();
        MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.miner.repair.enqueued", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
    }

    private void currentLevelClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        if (row != this.miner.current && row >= 0 && row < this.levelsInfo.size()) {
            this.miner.current = row;
            new MinerSetLevelMessage(this.buildingView, row).sendToServer();
        }
    }

    private void pullLevelsFromHut() {
        if (this.miner.getColony().getBuilding(this.buildingView.getID()) != null) {
            this.levelsInfo = this.miner.levelsInfo;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.levelList = (ScrollingList)this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutMinerModule.this.levelsInfo.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index == WindowHutMinerModule.this.miner.current) {
                    ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setColors(Color.getByName((String)"red", (int)0));
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setColors(Color.getByName((String)"black", (int)0));
                }
                if (WindowHutMinerModule.this.miner.doesWorkOrderExist(index)) {
                    ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_REPAIR, Button.class)).disable();
                }
                ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setText(Component.literal((String)Integer.toString(index)));
                ((Text)rowPane.findPaneOfTypeByID("nONodes", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.minernode", (Object[])new Object[0]).append(": ").append(String.valueOf(WindowHutMinerModule.this.levelsInfo.get(index).getA())));
                ((Text)rowPane.findPaneOfTypeByID("yLevel", Text.class)).setText(Component.literal((String)("Y: " + ((Integer)WindowHutMinerModule.this.levelsInfo.get(index).getB() + 1))));
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullLevelsFromHut();
    }
}

